/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.common;

import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai.GunShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.task.TaskGunAttack;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.SWarfareCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz.TacCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class GunCommonUtil {
    public static void initAndAddTask(TaskManager manager) {
        boolean tacz = TacCompat.init();
        boolean sbw = SWarfareCompat.init();
        if (tacz || sbw) {
            manager.add(new TaskGunAttack());
        }
    }

    public static boolean isInstalled() {
        return TacCompat.isInstalled() || SWarfareCompat.isInstalled();
    }

    public static boolean isGun(class_1799 stack) {
        return SWarfareCompat.isGun(stack) || TacCompat.isGun(stack);
    }

    public static boolean canStartAttacking(EntityMaid maid) {
        class_1657 player;
        class_1297 playerVehicle;
        class_1799 item = maid.method_6047();
        if (GunCommonUtil.isGun(item)) {
            return true;
        }
        class_1297 vehicle = maid.method_5854();
        if (vehicle != null) {
            return SWarfareCompat.isVehicle(vehicle);
        }
        class_1309 owner = maid.method_35057();
        if (owner instanceof class_1657 && (playerVehicle = (player = (class_1657)owner).method_5854()) != null && playerVehicle.method_5685().contains(maid)) {
            return SWarfareCompat.isVehicle(playerVehicle);
        }
        return false;
    }

    @Nullable
    public static class_2960 getGunId(class_1799 stack) {
        if (SWarfareCompat.isGun(stack)) {
            return SWarfareCompat.getGunId(stack);
        }
        if (TacCompat.isGun(stack)) {
            return TacCompat.getGunId(stack);
        }
        return null;
    }

    public static Optional<Boolean> canSee(EntityMaid maid, class_1309 target) {
        class_1799 handItem = maid.method_6047();
        if (TacCompat.isGun(handItem)) {
            return Optional.of(TacCompat.canSee(maid, target));
        }
        if (SWarfareCompat.isGun(handItem)) {
            return Optional.of(SWarfareCompat.canSee(maid, target));
        }
        return SWarfareCompat.canVehicleSee(maid, target);
    }

    public static void tick(EntityMaid shooter, class_1309 target, class_1799 gunItem) {
        if (SWarfareCompat.isGun(gunItem)) {
            SWarfareCompat.tick(shooter, target, gunItem);
        }
    }

    public static int performGunAttack(EntityMaid shooter, class_1309 target, class_1799 gunItem) throws Exception {
        if (TacCompat.isGun(gunItem)) {
            return TacCompat.performGunAttack(shooter, target, gunItem);
        }
        if (SWarfareCompat.isGun(gunItem)) {
            return SWarfareCompat.performGunAttack(shooter, target, gunItem);
        }
        return 100;
    }

    public static void onStop(EntityMaid maid, GunShootTargetTask task) {
        TacCompat.stopAim(maid);
        SWarfareCompat.onStop(maid, task);
    }
}

