/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.common.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.GunCommonUtil;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai.GunAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai.GunShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidUseShieldTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_7893;

public class TaskGunAttack
implements IRangedAttackTask {
    public static final class_2960 UID = new class_2960("touhou_little_maid", "gun_attack");
    public static final class_1799 ICON = InitItems.TACZ_GUN_ICON.method_7854();

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        return ICON;
    }

    @Override
    @Nullable
    public class_3414 getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, InitSounds.MAID_RANGE_ATTACK, 0.5f);
    }

    @Override
    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        return false;
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(this::mainhandHoldGun, IRangedAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.mainhandHoldGun(maid) || this.farAway((class_1309)target, maid));
        class_7893<EntityMaid> gunWalkTargetTask = MaidRangedWalkToTarget.create(0.6f);
        GunAttackStrafingTask gunAttackStrafingTask = new GunAttackStrafingTask();
        GunShootTargetTask gunShootTargetTask = new GunShootTargetTask();
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, gunWalkTargetTask), Pair.of((Object)5, (Object)((Object)gunAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)gunShootTargetTask)), Pair.of((Object)5, (Object)((Object)maidUseShieldTask))});
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(GunCommonUtil::canStartAttacking, IRangedAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !GunCommonUtil.canStartAttacking(maid) || this.farAway((class_1309)target, maid));
        GunShootTargetTask gunShootTargetTask = new GunShootTargetTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)((Object)gunShootTargetTask))});
    }

    @Override
    public class_238 searchDimension(EntityMaid maid) {
        if (GunCommonUtil.canStartAttacking(maid)) {
            float searchRange = this.searchRadius(maid);
            if (maid.method_18410()) {
                return new class_238(maid.method_18412()).method_1014((double)searchRange);
            }
            return maid.method_5829().method_1014((double)searchRange);
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        return ((Integer)MaidConfig.MAID_GUN_LONG_DISTANCE.get()).intValue();
    }

    @Override
    public boolean canSee(EntityMaid maid, class_1309 target) {
        return GunCommonUtil.canSee(maid, target).orElseGet(() -> IRangedAttackTask.super.canSee(maid, target));
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.singletonList(Pair.of((Object)"has_gun", m -> this.isWeapon((EntityMaid)m, m.method_6047())));
    }

    @Override
    public boolean isWeapon(EntityMaid maid, class_1799 stack) {
        return GunCommonUtil.isGun(stack);
    }

    private boolean farAway(class_1309 target, EntityMaid maid) {
        return maid.method_5739((class_1297)target) > this.searchRadius(maid);
    }

    private boolean mainhandHoldGun(EntityMaid maid) {
        class_1799 item = maid.method_6047();
        return this.isWeapon(maid, item);
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, class_1309 target, float distanceFactor) {
    }
}

