/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare;

import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.entity.projectile.RgoGrenadeEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.HandGrenade;
import com.atsuishio.superbwarfare.item.RgoGrenade;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai.GunShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.SWarfareCompat;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidAnimationMessage;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3419;
import net.minecraft.class_4215;

public class SWarfareCompatInner {
    static boolean isGun(class_1799 stack) {
        return stack.method_7909() instanceof GunItem;
    }

    static boolean isGrenade(class_1799 stack) {
        return stack.method_7909() instanceof HandGrenade;
    }

    static boolean isVehicle(class_1297 entity) {
        return entity instanceof VehicleEntity;
    }

    static boolean shouldHideLivingRender(class_1309 maid) {
        class_1297 class_12972 = maid.method_5854();
        if (class_12972 instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)class_12972;
            return vehicle.hidePassenger((class_1297)maid);
        }
        return false;
    }

    static boolean canSee(EntityMaid maid, class_1309 target) {
        class_1799 handItem = maid.method_6047();
        if (!(handItem.method_7909() instanceof GunItem)) {
            return class_4215.method_24565((class_1309)maid, (class_1309)target);
        }
        GunData gunData = GunData.from((class_1799)handItem);
        if (gunData == null) {
            return maid.canSee(target);
        }
        if (handItem.method_31573(SWarfareCompat.SNIPER)) {
            return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
        }
        if (handItem.method_31573(SWarfareCompat.PISTOL) || handItem.method_31573(SWarfareCompat.SMG) || handItem.method_31573(SWarfareCompat.SHOOTGUN)) {
            return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_NEAR_DISTANCE);
        }
        return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_MEDIUM_DISTANCE);
    }

    static Optional<Boolean> canVehicleSee(EntityMaid maid, class_1309 target) {
        class_1657 player;
        class_1297 playerVehicle;
        class_1297 vehicle = maid.method_5854();
        if (vehicle != null && SWarfareCompat.isVehicle(vehicle)) {
            boolean canSee = IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
            return Optional.of(canSee);
        }
        class_1309 owner = maid.method_35057();
        if (owner instanceof class_1657 && (playerVehicle = (player = (class_1657)owner).method_5854()) != null && playerVehicle.method_5685().contains(maid) && SWarfareCompat.isVehicle(playerVehicle)) {
            boolean canSee = IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
            return Optional.of(canSee);
        }
        return Optional.empty();
    }

    static void tick(EntityMaid shooter, class_1309 target, class_1799 gunItem) {
        if (!(gunItem.method_7909() instanceof GunItem)) {
            return;
        }
        GunData gunData = GunData.from((class_1799)gunItem);
        if (gunData == null) {
            return;
        }
        gunData.tick((class_1297)shooter, true);
    }

    static void onStop(EntityMaid maid, GunShootTargetTask task) {
        class_1799 offhand = maid.method_6079();
        if (offhand.method_7909() instanceof RgoGrenade) {
            task.setAttackCooldown(50);
        }
    }

    static int performGunAttack(EntityMaid shooter, class_1309 target, class_1799 gunItem) {
        if (!(gunItem.method_7909() instanceof GunItem)) {
            return 100;
        }
        GunData gunData = GunData.from((class_1799)gunItem);
        if (gunData == null) {
            return 100;
        }
        int result = SWarfareCompatInner.doGunReload(shooter, gunData);
        if (result > 0) {
            return result;
        }
        if (!gunData.canShoot((class_1297)shooter)) {
            SWarfareCompatInner.useGrenade(shooter, target);
            return 50;
        }
        return SWarfareCompatInner.doGunShoot(shooter, target, gunItem, gunData);
    }

    private static void useGrenade(EntityMaid shooter, class_1309 target) {
        class_1799 offhand = shooter.method_6079();
        if (offhand.method_7909() instanceof RgoGrenade && shooter.method_5739((class_1297)target) <= 16.0f) {
            SWarfareCompatInner.setViewRot(shooter, target);
            float power = 1.2f + shooter.method_6051().method_43057() * 0.4f;
            RgoGrenadeEntity rgoGrenade = new RgoGrenadeEntity((class_1309)shooter, shooter.field_6002, 40);
            rgoGrenade.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454(), 0.0f, power, 0.0f);
            shooter.field_6002.method_8649((class_1297)rgoGrenade);
            shooter.field_6002.method_8396(null, shooter.method_24515(), ModSounds.GRENADE_THROW, class_3419.field_15254, 1.0f, 1.0f);
            offhand.method_7934(1);
        }
    }

    private static int doGunReload(EntityMaid shooter, GunData gunData) {
        if (gunData.shouldStartReloading((class_1297)shooter)) {
            gunData.startReload();
            NetworkHandler.sendToTrackingEntity((class_1297)shooter, MaidAnimationMessage.ID, MaidAnimationMessage.encode(shooter.method_5628(), 3));
            return 5;
        }
        if (gunData.shouldStartBolt()) {
            gunData.startBolt();
            NetworkHandler.sendToTrackingEntity((class_1297)shooter, MaidAnimationMessage.ID, MaidAnimationMessage.encode(shooter.method_5628(), 3));
            return 5;
        }
        return -1;
    }

    private static int doGunShoot(EntityMaid shooter, class_1309 target, class_1799 gunItem, GunData gunData) {
        boolean isSniper = gunItem.method_31573(SWarfareCompat.SNIPER);
        if (isSniper && !shooter.isAiming()) {
            shooter.setAiming(true);
            return 20;
        }
        if (!isSniper) {
            float radius;
            float distance = shooter.method_5739((class_1297)target);
            if (distance <= (radius = shooter.method_18413()) && shooter.isAiming()) {
                shooter.setAiming(false);
                return 10;
            }
            if (distance > radius && !shooter.isAiming()) {
                shooter.setAiming(true);
                return 20;
            }
        }
        double rps = (double)((Integer)gunData.get(GunProp.RPM)).intValue() / 60.0;
        int cooldown = (int)Math.round(20.0 / rps);
        FireMode fireMode = (FireMode)gunData.fireMode.get();
        if (fireMode == FireMode.SEMI || fireMode == FireMode.BURST && gunData.burstAmount.get() == 0) {
            cooldown += 5 + shooter.method_6051().method_43048(5);
        }
        SWarfareCompatInner.setViewRot(shooter, target);
        gunData.shoot((class_1297)shooter, 0.0, shooter.isAiming(), target.method_5667());
        NetworkHandler.sendToTrackingEntity((class_1297)shooter, MaidAnimationMessage.ID, MaidAnimationMessage.encode(shooter.method_5628(), 4));
        return cooldown;
    }

    private static void setViewRot(EntityMaid shooter, class_1309 target) {
        double x = target.method_23317() - shooter.method_23317();
        double y = target.method_23320() - shooter.method_23320();
        double z = target.method_23321() - shooter.method_23321();
        float yaw = (float)(-Math.toDegrees(Math.atan2(x, z)));
        float pitch = (float)(-Math.toDegrees(Math.atan2(y, Math.sqrt(x * x + z * z))));
        shooter.method_36457(pitch);
        shooter.method_36456(yaw);
    }
}

