/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.recipe;

import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCraftingHelper;
import com.google.gson.JsonParseException;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class AltarOutputJS {
    @Info(value="Converting KubeJS' Item object to the altar's' output item object", params={@Param(name="stack", value="The ItemStack to convert to an altar output item.")})
    public static EntityCraftingHelper.Output item(class_1799 stack) {
        class_1299 item = class_1299.field_6052;
        class_2487 data = new class_2487();
        data.method_10566("Item", (class_2520)stack.method_7953(new class_2487()));
        return new EntityCraftingHelper.Output(item, data);
    }

    @Info(value="Directly converting an entity ID and extra NBT data to the altar's output entity object", params={@Param(name="entityId", value="The ID of the entity type to output."), @Param(name="data", value="Additional NBT data to attach to the entity.")})
    public static EntityCraftingHelper.Output entity(String entityId, class_2487 data) {
        Optional value = class_7923.field_41177.method_17966(new class_2960(entityId));
        if (value.isEmpty()) {
            throw new JsonParseException("Entity Type Not Found: " + entityId);
        }
        return new EntityCraftingHelper.Output((class_1299)value.get(), data);
    }

    @Info(value="Directly converting an entity ID to the altar's output entity object with empty NBT data", params={@Param(name="entityId", value="The ID of the entity type to output.")})
    public static EntityCraftingHelper.Output entity(String entityId) {
        return AltarOutputJS.entity(entityId, new class_2487());
    }

    @Info(value="Spawn a new maid with a cake box")
    public static EntityCraftingHelper.Output spawnMaidWithBox() {
        class_2960 key = class_7923.field_41177.method_10221(InitEntities.MAID);
        if (key == class_7923.field_41177.method_10137()) {
            throw new JsonParseException("Maid Entity Type Not Found");
        }
        class_2487 data = new class_2487();
        class_2499 passengers = new class_2499();
        class_2487 maid = new class_2487();
        maid.method_10582("id", key.toString());
        passengers.add((Object)maid);
        data.method_10566("Passengers", (class_2520)passengers);
        return new EntityCraftingHelper.Output(InitEntities.MAID, data);
    }

    @Info(value="Reborn the maid from film, the ingredient must have a film")
    public static EntityCraftingHelper.Output rebornMaid() {
        return new EntityCraftingHelper.Output(InitEntities.MAID, new class_2487(), class_1856.method_8091((class_1935[])new class_1935[]{InitItems.FILM}), "MaidInfo");
    }
}

