/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.builder;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.meal.MaidMealType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.BaubleManager;
import com.github.tartaricacid.touhoulittlemaid.util.functional.QuadConsumer;
import com.github.tartaricacid.touhoulittlemaid.util.functional.QuadFunction;
import com.github.tartaricacid.touhoulittlemaid.util.functional.TriConsumer;
import com.github.tartaricacid.touhoulittlemaid.util.functional.TriFunction;
import com.google.common.collect.Maps;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.apache.commons.lang3.mutable.MutableFloat;

public class MaidBaubleBuilder {
    private final Map<class_1792, CustomKubeJSBauble> baubles = Maps.newHashMap();

    @Info(value="Bind an item to a maid bauble. And specify a callback function that will be called every tick of the maid. <br>\n\u5c06\u7269\u54c1\u4e0e\u5973\u4ec6\u9970\u54c1\u7ed1\u5b9a\u3002\u5e76\u4e14\u53ef\u4ee5\u6307\u5b9a\u4e00\u4e2a\u56de\u8c03\u51fd\u6570\uff0c\u5728\u5973\u4ec6\u6bcf\u6b21 tick \u65f6\u8c03\u7528\u3002\n")
    @Deprecated
    public CustomKubeJSBauble bind(class_1792 item, @Nullable BiConsumer<EntityMaid, class_1799> onTick) {
        CustomKubeJSBauble bauble = new CustomKubeJSBauble();
        bauble.onTick = onTick;
        this.baubles.put(item, bauble);
        return bauble;
    }

    @Info(value="Bind an item to a maid bauble. <br>\n\u5c06\u7269\u54c1\u4e0e\u5973\u4ec6\u9970\u54c1\u7ed1\u5b9a\u3002\n")
    public CustomKubeJSBauble bind(class_1792 item) {
        CustomKubeJSBauble bauble = new CustomKubeJSBauble();
        this.baubles.put(item, bauble);
        return bauble;
    }

    @HideFromJS
    public void register(BaubleManager manager) {
        this.baubles.forEach(manager::bind);
        this.baubles.clear();
    }

    public static class CustomKubeJSBauble
    implements IMaidBauble {
        @HideFromJS
        @Nullable
        private BiConsumer<EntityMaid, class_1799> onTick = null;
        @HideFromJS
        @Nullable
        private QuadFunction<EntityMaid, class_1799, class_1282, MutableFloat, Boolean> onInjured = null;
        @HideFromJS
        @Nullable
        private TriFunction<EntityMaid, class_1799, class_1282, Boolean> onDeath = null;
        @HideFromJS
        @Nullable
        private BiConsumer<EntityMaid, class_1799> onPutOn = null;
        @HideFromJS
        @Nullable
        private BiConsumer<EntityMaid, class_1799> onTakeOff = null;
        @HideFromJS
        @Nullable
        private TriConsumer<EntityMaid, class_1799, class_1297> onMeleeAttack = null;
        @HideFromJS
        @Nullable
        private TriConsumer<EntityMaid, class_1799, IRangedAttackTask> onRangedAttack = null;
        @HideFromJS
        @Nullable
        private QuadConsumer<EntityMaid, class_1799, class_1799, MaidMealType> onMaidEat = null;
        @HideFromJS
        @Nullable
        private QuadConsumer<EntityMaid, class_1799, Integer, Integer> onFavorabilityLevelChange = null;

        @Info(value="When equipped as a bauble, this callback is called every tick. <br>\n\u5f53\u88c5\u5907\u9970\u54c1\u65f6\uff0c\u6bcf tick \u4f1a\u8c03\u7528\u6b64\u56de\u8c03\u3002\n")
        public CustomKubeJSBauble triggerTick(@Nullable BiConsumer<EntityMaid, class_1799> c) {
            this.onTick = c;
            return this;
        }

        @Info(value="When the maid is injured while wearing this bauble, this callback is called. <br>\nReturning true indicates that subsequent damage processing is canceled. <br>\n\u5f53\u5973\u4ec6\u5728\u4f69\u6234\u6b64\u9970\u54c1\u65f6\u53d7\u5230\u4f24\u5bb3\uff0c\u4f1a\u8c03\u7528\u6b64\u56de\u8c03\u3002\u8fd4\u56de true \u8868\u793a\u53d6\u6d88\u540e\u7eed\u4f24\u5bb3\u5904\u7406\u3002\n")
        public CustomKubeJSBauble triggerInjured(@Nullable QuadFunction<EntityMaid, class_1799, class_1282, MutableFloat, Boolean> f) {
            this.onInjured = f;
            return this;
        }

        @Info(value="When the maid dies while wearing this bauble, this callback is called. <br>\nReturning true indicates that subsequent death processing is canceled. <br>\n\u5f53\u5973\u4ec6\u5728\u4f69\u6234\u6b64\u9970\u54c1\u65f6\u6b7b\u4ea1\uff0c\u4f1a\u8c03\u7528\u6b64\u56de\u8c03\u3002\u8fd4\u56de true \u8868\u793a\u53d6\u6d88\u540e\u7eed\u6b7b\u4ea1\u5904\u7406\u3002\n")
        public CustomKubeJSBauble triggerDeath(@Nullable TriFunction<EntityMaid, class_1799, class_1282, Boolean> f) {
            this.onDeath = f;
            return this;
        }

        @Info(value="When player equips this bauble to the maid, this callback is called once. <br>\nCan be used to modify the maid's attributes. <br>\n\u5f53\u73a9\u5bb6\u7ed9\u5973\u4ec6\u88c5\u5907\u6b64\u9970\u54c1\u65f6\uff0c\u4f1a\u8c03\u7528\u4e00\u6b21\u6b64\u56de\u8c03\uff0c\u53ef\u7528\u4e8e\u4fee\u6539\u5973\u4ec6\u7684 attribute\u3002\n")
        public CustomKubeJSBauble triggerPutOn(@Nullable BiConsumer<EntityMaid, class_1799> c) {
            this.onPutOn = c;
            return this;
        }

        @Info(value="When player removes this bauble from the maid, this callback is called once. <br>\nCan be used to revert the maid's attributes modified by `triggerPutOn`. <br>\n\u5f53\u73a9\u5bb6\u4ece\u5973\u4ec6\u8eab\u4e0a\u79fb\u9664\u6b64\u9970\u54c1\u65f6\uff0c\u4f1a\u8c03\u7528\u4e00\u6b21\u6b64\u56de\u8c03\u3002\u53ef\u7528\u4e8e\u8fd8\u539f `triggerPutOn` \u4fee\u6539\u7684\u5973\u4ec6 attribute\u3002\n")
        public CustomKubeJSBauble triggerTakeOff(@Nullable BiConsumer<EntityMaid, class_1799> c) {
            this.onTakeOff = c;
            return this;
        }

        @Info(value="When the maid performs a melee attack while wearing this bauble, this callback is called. <br>\n\u5f53\u5973\u4ec6\u5728\u4f69\u6234\u6b64\u9970\u54c1\u65f6\u8fdb\u884c\u8fd1\u6218\u653b\u51fb\uff0c\u4f1a\u8c03\u7528\u6b64\u56de\u8c03\u3002\n")
        public CustomKubeJSBauble triggerMeleeAttack(@Nullable TriConsumer<EntityMaid, class_1799, class_1297> c) {
            this.onMeleeAttack = c;
            return this;
        }

        @Info(value="When the maid performs a ranged attack while wearing this bauble, this callback is called. <br>\n\u5f53\u5973\u4ec6\u5728\u4f69\u6234\u6b64\u9970\u54c1\u65f6\u8fdb\u884c\u8fdc\u7a0b\u653b\u51fb\uff0c\u4f1a\u8c03\u7528\u6b64\u56de\u8c03\u3002\n")
        public CustomKubeJSBauble triggerRangedAttack(@Nullable TriConsumer<EntityMaid, class_1799, IRangedAttackTask> c) {
            this.onRangedAttack = c;
            return this;
        }

        @Info(value="When the maid eats food while wearing this bauble, this callback is called. <br>\n\u5f53\u5973\u4ec6\u5728\u4f69\u6234\u6b64\u9970\u54c1\u65f6\u8fdb\u98df\u98df\u7269\uff0c\u4f1a\u8c03\u7528\u6b64\u56de\u8c03\u3002\n")
        public CustomKubeJSBauble triggerMaidEat(@Nullable QuadConsumer<EntityMaid, class_1799, class_1799, MaidMealType> c) {
            this.onMaidEat = c;
            return this;
        }

        @Info(value="When the maid's favorability level changes while wearing this bauble, this callback is called. <br>\n\u5f53\u5973\u4ec6\u5728\u4f69\u6234\u6b64\u9970\u54c1\u65f6\u597d\u611f\u5ea6\u7b49\u7ea7\u53d8\u5316\uff0c\u4f1a\u8c03\u7528\u6b64\u56de\u8c03\u3002\n")
        public CustomKubeJSBauble triggerFavorabilityLevelChange(@Nullable QuadConsumer<EntityMaid, class_1799, Integer, Integer> c) {
            this.onFavorabilityLevelChange = c;
            return this;
        }

        @Override
        @HideFromJS
        public void onTick(EntityMaid maid, class_1799 baubleItem) {
            if (this.onTick != null) {
                this.onTick.accept(maid, baubleItem);
            }
        }

        @Override
        @HideFromJS
        public boolean onInjured(EntityMaid maid, class_1799 baubleItem, class_1282 source, MutableFloat amount) {
            if (this.onInjured != null) {
                Boolean ret = this.onInjured.apply(maid, baubleItem, source, amount);
                return ret != null && ret != false;
            }
            return false;
        }

        @Override
        @HideFromJS
        public boolean onDeath(EntityMaid maid, class_1799 baubleItem, class_1282 source) {
            if (this.onDeath != null) {
                Boolean ret = this.onDeath.apply(maid, baubleItem, source);
                return ret != null && ret != false;
            }
            return false;
        }

        @Override
        @HideFromJS
        public void onPutOn(EntityMaid maid, class_1799 baubleItem) {
            if (this.onPutOn != null) {
                this.onPutOn.accept(maid, baubleItem);
            }
        }

        @Override
        @HideFromJS
        public void onTakeOff(EntityMaid maid, class_1799 baubleItem) {
            if (this.onTakeOff != null) {
                this.onTakeOff.accept(maid, baubleItem);
            }
        }

        @Override
        @HideFromJS
        public void onMeleeAttack(EntityMaid maid, class_1799 baubleItem, class_1297 target) {
            if (this.onMeleeAttack != null) {
                this.onMeleeAttack.accept(maid, baubleItem, target);
            }
        }

        @Override
        @HideFromJS
        public void onRangedAttack(EntityMaid maid, class_1799 baubleItem, IRangedAttackTask task) {
            if (this.onRangedAttack != null) {
                this.onRangedAttack.accept(maid, baubleItem, task);
            }
        }

        @Override
        @HideFromJS
        public void onMaidEat(EntityMaid maid, class_1799 baubleItem, class_1799 foodItem, MaidMealType mealType) {
            if (this.onMaidEat != null) {
                this.onMaidEat.accept(maid, baubleItem, foodItem, mealType);
            }
        }

        @Override
        @HideFromJS
        public void onFavorabilityLevelChange(EntityMaid maid, class_1799 baubleItem, int oldLevel, int newLevel) {
            if (this.onFavorabilityLevelChange != null) {
                this.onFavorabilityLevelChange.accept(maid, baubleItem, oldLevel, newLevel);
            }
        }
    }
}

