/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task.TaskBuilder;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidUseShieldTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4816;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_7893;
import net.minecraft.class_7894;
import org.jetbrains.annotations.Nullable;

public class MeleeTaskJS
implements IAttackTask {
    private final Builder builder;

    public MeleeTaskJS(Builder builder) {
        this.builder = builder;
    }

    @Override
    public class_2960 getUid() {
        return this.builder.id;
    }

    @Override
    public class_1799 getIcon() {
        return this.builder.icon;
    }

    @Override
    @Nullable
    public class_3414 getAmbientSound(EntityMaid maid) {
        if (this.builder.sound == null) {
            return SoundUtil.attackSound(maid, InitSounds.MAID_ATTACK, 0.5f);
        }
        return this.builder.sound;
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(m -> this.isWeapon((EntityMaid)m, m.method_6047()), IAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.isWeapon(maid, maid.method_6047()) || maid.method_5739((class_1297)target) > maid.method_18413());
        class_7893 moveToTargetTask = class_4822.method_47094((float)this.builder.walkSpeed);
        class_7894 attackTargetTask = class_4816.method_46987((int)this.builder.meleeCooldownTick);
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();
        ArrayList tasks = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)moveToTargetTask), Pair.of((Object)5, (Object)attackTargetTask), Pair.of((Object)5, (Object)((Object)maidUseShieldTask))});
        for (Pair pair : this.builder.brains) {
            tasks.add(Pair.of((Object)((Integer)pair.getFirst()), (Object)((class_7893)((BiFunction)pair.getSecond()).apply(this, maid))));
        }
        return tasks;
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(m -> this.isWeapon((EntityMaid)m, m.method_6047()), IAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.isWeapon(maid, maid.method_6047()) || this.farAway((class_1309)target, maid));
        class_7894 attackTargetTask = class_4816.method_46987((int)this.builder.meleeCooldownTick);
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();
        ArrayList tasks = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)attackTargetTask), Pair.of((Object)5, (Object)((Object)maidUseShieldTask))});
        for (Pair pair : this.builder.rideBrains) {
            tasks.add(Pair.of((Object)((Integer)pair.getFirst()), (Object)((class_7893)((BiFunction)pair.getSecond()).apply(this, maid))));
        }
        return tasks;
    }

    @Override
    public boolean isEnable(EntityMaid maid) {
        if (this.builder.enable == null) {
            return true;
        }
        return this.builder.enable.test(maid);
    }

    @Override
    public boolean isHidden(EntityMaid maid) {
        if (this.builder.isHidden == null) {
            return false;
        }
        return this.builder.isHidden.test(maid);
    }

    @Override
    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        if (this.builder.enableLookAndRandomWalk == null) {
            return true;
        }
        return this.builder.enableLookAndRandomWalk.test(maid);
    }

    @Override
    public boolean enableEating(EntityMaid maid) {
        if (this.builder.enableEating == null) {
            return true;
        }
        return this.builder.enableEating.test(maid);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getEnableConditionDesc(EntityMaid maid) {
        return this.builder.enableConditionDesc;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return this.builder.conditionDesc;
    }

    @Override
    public boolean canAttack(EntityMaid maid, class_1309 target) {
        if (this.builder.canAttack == null) {
            return IAttackTask.super.canAttack(maid, target);
        }
        return this.builder.canAttack.test(maid, target);
    }

    @Override
    public boolean hasExtraAttack(EntityMaid maid, class_1297 target) {
        if (this.builder.hasExtraAttack == null) {
            return false;
        }
        return this.builder.hasExtraAttack.test(maid, target);
    }

    @Override
    public boolean doExtraAttack(EntityMaid maid, class_1297 target) {
        if (this.builder.doExtraAttack == null) {
            return false;
        }
        return this.builder.doExtraAttack.test(maid, target);
    }

    @Override
    public boolean isWeapon(EntityMaid maid, class_1799 stack) {
        if (this.builder.isWeapon == null) {
            return false;
        }
        return this.builder.isWeapon.test(maid, stack);
    }

    private boolean farAway(class_1309 target, EntityMaid maid) {
        if (!target.method_5805()) {
            return true;
        }
        boolean enable = maid.isHomeModeEnable();
        float radius = maid.method_18413();
        if (!enable && maid.method_35057() != null) {
            return maid.method_35057().method_5739((class_1297)target) > radius;
        }
        return maid.method_5739((class_1297)target) > radius;
    }

    public static class Builder
    extends TaskBuilder<Builder, MeleeTaskJS> {
        @Nullable
        private BiPredicate<EntityMaid, class_1309> canAttack = null;
        @Nullable
        private BiPredicate<EntityMaid, class_1297> hasExtraAttack = null;
        @Nullable
        private BiPredicate<EntityMaid, class_1297> doExtraAttack = null;
        @Nullable
        private BiPredicate<EntityMaid, class_1799> isWeapon = null;
        private float walkSpeed = 0.6f;
        private int meleeCooldownTick = 20;

        public Builder(class_2960 id, class_1799 icon) {
            super(id, icon);
        }

        @Info(value="Sets the condition for whether the maid can attack a target. Default is all hostile entities. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u662f\u5426\u53ef\u4ee5\u653b\u51fb\u76ee\u6807\u7684\u6761\u4ef6\u3002\u9ed8\u8ba4\u4e3a\u6240\u6709\u654c\u5bf9\u751f\u7269\u3002\n")
        public Builder canAttack(BiPredicate<EntityMaid, class_1309> canAttack) {
            this.canAttack = canAttack;
            return this;
        }

        @Info(value="Sets the condition for whether the maid has an extra attack against a target. Default is false. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u662f\u5426\u5bf9\u76ee\u6807\u6709\u989d\u5916\u653b\u51fb\u7684\u6761\u4ef6\u3002\u9ed8\u8ba4\u4e3a false\u3002\n")
        public Builder hasExtraAttack(BiPredicate<EntityMaid, class_1297> hasExtraAttack) {
            this.hasExtraAttack = hasExtraAttack;
            return this;
        }

        @Info(value="Sets the action for the maid to perform an extra attack against a target. Default is empty. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u5bf9\u76ee\u6807\u6267\u884c\u989d\u5916\u653b\u51fb\u7684\u52a8\u4f5c\u3002\u9ed8\u8ba4\u4e3a\u7a7a\u3002\n")
        public Builder doExtraAttack(BiPredicate<EntityMaid, class_1297> doExtraAttack) {
            this.doExtraAttack = doExtraAttack;
            return this;
        }

        @Info(value="Sets the condition for whether the maid considers an item as a weapon. Mandatory. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u662f\u5426\u5c06\u5f53\u524d\u7269\u54c1\u89c6\u4e3a\u6b66\u5668\u7684\u6761\u4ef6\u3002\u5fc5\u586b\u9879\u3002\n")
        public Builder isWeapon(BiPredicate<EntityMaid, class_1799> isWeapon) {
            this.isWeapon = isWeapon;
            return this;
        }

        @Info(value="Sets the walk speed for the maid when moving towards a target. Default is 0.6. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u5728\u63a5\u8fd1\u76ee\u6807\u65f6\u7684\u79fb\u52a8\u901f\u5ea6\u3002\u9ed8\u8ba4\u4e3a 0.6\u3002\n")
        public Builder walkSpeed(float walkSpeed) {
            this.walkSpeed = walkSpeed;
            return this;
        }

        @Info(value="Sets the cooldown tick for the attack. Default is 20 ticks. <br>\n\u8bbe\u7f6e\u653b\u51fb\u7684\u51b7\u5374\u65f6\u95f4\uff08\u4ee5 tick \u4e3a\u5355\u4f4d\uff09\u3002\u9ed8\u8ba4\u503c\u4e3a 20 ticks\u3002\n")
        public Builder meleeCooldownTick(int meleeCooldownTick) {
            this.meleeCooldownTick = meleeCooldownTick;
            return this;
        }
    }
}

