/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task.TaskBuilder;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAttackStrafingAnyItemTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidShootTargetAnyItemTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.github.tartaricacid.touhoulittlemaid.util.functional.TriConsumer;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_7893;
import org.jetbrains.annotations.Nullable;

public class RangedAttackTaskJS
implements IRangedAttackTask {
    private final Builder builder;

    public RangedAttackTaskJS(Builder builder) {
        this.builder = builder;
    }

    @Override
    public class_2960 getUid() {
        return this.builder.id;
    }

    @Override
    public class_1799 getIcon() {
        return this.builder.icon;
    }

    @Override
    @Nullable
    public class_3414 getAmbientSound(EntityMaid maid) {
        if (this.builder.sound == null) {
            return SoundUtil.attackSound(maid, InitSounds.MAID_RANGE_ATTACK, 0.5f);
        }
        return this.builder.sound;
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(m -> this.isWeapon((EntityMaid)m, m.method_6047()), IAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.isWeapon(maid, maid.method_6047()) || maid.method_5739((class_1297)target) > this.searchRadius(maid));
        class_7893<EntityMaid> moveToTargetTask = MaidRangedWalkToTarget.create(this.builder.walkSpeed);
        MaidAttackStrafingAnyItemTask maidAttackStrafingTask = new MaidAttackStrafingAnyItemTask(stack -> this.isWeapon(maid, (class_1799)stack), this.builder.projectileRange, this.builder.walkSpeed);
        MaidShootTargetAnyItemTask shootTargetTask = new MaidShootTargetAnyItemTask(2, this.builder.chargeDurationTick, stack -> this.isWeapon(maid, (class_1799)stack));
        ArrayList tasks = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, moveToTargetTask), Pair.of((Object)5, (Object)((Object)maidAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
        for (Pair pair : this.builder.brains) {
            tasks.add(Pair.of((Object)((Integer)pair.getFirst()), (Object)((class_7893)((BiFunction)pair.getSecond()).apply(this, maid))));
        }
        return tasks;
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(m -> this.isWeapon((EntityMaid)m, m.method_6047()), IAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.isWeapon(maid, maid.method_6047()) || maid.method_5739((class_1297)target) > this.searchRadius(maid));
        MaidShootTargetAnyItemTask shootTargetTask = new MaidShootTargetAnyItemTask(2, this.builder.chargeDurationTick, stack -> this.isWeapon(maid, (class_1799)stack));
        ArrayList tasks = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
        for (Pair pair : this.builder.rideBrains) {
            tasks.add(Pair.of((Object)((Integer)pair.getFirst()), (Object)((class_7893)((BiFunction)pair.getSecond()).apply(this, maid))));
        }
        return tasks;
    }

    @Override
    public boolean isEnable(EntityMaid maid) {
        if (this.builder.enable == null) {
            return true;
        }
        return this.builder.enable.test(maid);
    }

    @Override
    public boolean isHidden(EntityMaid maid) {
        if (this.builder.isHidden == null) {
            return false;
        }
        return this.builder.isHidden.test(maid);
    }

    @Override
    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        if (this.builder.enableLookAndRandomWalk == null) {
            return true;
        }
        return this.builder.enableLookAndRandomWalk.test(maid);
    }

    @Override
    public boolean enableEating(EntityMaid maid) {
        if (this.builder.enableEating == null) {
            return true;
        }
        return this.builder.enableEating.test(maid);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getEnableConditionDesc(EntityMaid maid) {
        return this.builder.enableConditionDesc;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return this.builder.conditionDesc;
    }

    @Override
    public boolean canAttack(EntityMaid maid, class_1309 target) {
        if (this.builder.canAttack == null) {
            return IRangedAttackTask.super.canAttack(maid, target);
        }
        return this.builder.canAttack.test(maid, target);
    }

    @Override
    public boolean isWeapon(EntityMaid maid, class_1799 stack) {
        if (this.builder.isWeapon == null) {
            return false;
        }
        return this.builder.isWeapon.test(maid, stack);
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, class_1309 target, float distanceFactor) {
        if (this.builder.performRangedAttack != null) {
            this.builder.performRangedAttack.accept(shooter, target, Float.valueOf(distanceFactor));
        }
    }

    @Override
    public boolean canSee(EntityMaid maid, class_1309 target) {
        return TARGET_CONDITIONS.method_18418((double)this.searchRadius(maid)).method_18419((class_1309)maid, target);
    }

    @Override
    public class_238 searchDimension(EntityMaid maid) {
        if (this.isWeapon(maid, maid.method_6047())) {
            float searchRange = this.searchRadius(maid);
            if (maid.method_18410()) {
                return new class_238(maid.method_18412()).method_1014((double)searchRange);
            }
            return maid.method_5829().method_1014((double)searchRange);
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        if (this.builder.searchRadius > 0.0f) {
            return this.builder.searchRadius;
        }
        return IRangedAttackTask.super.searchRadius(maid);
    }

    public static class Builder
    extends TaskBuilder<Builder, RangedAttackTaskJS> {
        @Nullable
        private BiPredicate<EntityMaid, class_1309> canAttack = null;
        @Nullable
        private BiPredicate<EntityMaid, class_1799> isWeapon = null;
        @Nullable
        private TriConsumer<EntityMaid, class_1309, Float> performRangedAttack = null;
        private float searchRadius = -1.0f;
        private float projectileRange = 16.0f;
        private int chargeDurationTick = 20;
        private float walkSpeed = 0.5f;

        public Builder(class_2960 id, class_1799 icon) {
            super(id, icon);
        }

        @Info(value="Sets the condition for whether the maid can attack a target. Default is all hostile entities. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u662f\u5426\u53ef\u4ee5\u653b\u51fb\u76ee\u6807\u7684\u6761\u4ef6\u3002\u9ed8\u8ba4\u4e3a\u6240\u6709\u654c\u5bf9\u751f\u7269\u3002\n")
        public Builder canAttack(BiPredicate<EntityMaid, class_1309> canAttack) {
            this.canAttack = canAttack;
            return this;
        }

        @Info(value="Sets the condition for whether the maid considers an item as a weapon. Mandatory. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u662f\u5426\u5c06\u5f53\u524d\u7269\u54c1\u89c6\u4e3a\u6b66\u5668\u7684\u6761\u4ef6\u3002\u5fc5\u586b\u9879\u3002\n")
        public Builder isWeapon(BiPredicate<EntityMaid, class_1799> isWeapon) {
            this.isWeapon = isWeapon;
            return this;
        }

        @Info(value="Sets the search radius for the maid to find targets. Default is the work range, you can increase this value for long-range attacks. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u5bfb\u627e\u76ee\u6807\u7684\u641c\u7d22\u534a\u5f84\u3002\u9ed8\u8ba4\u4e3a\u5de5\u4f5c\u8303\u56f4\uff0c\u4f60\u53ef\u4ee5\u8c03\u5927\u6b64\u6570\u503c\u5b9e\u73b0\u8d85\u89c6\u8ddd\u6253\u51fb\u3002\n")
        public Builder searchRadius(float radius) {
            this.searchRadius = radius;
            return this;
        }

        @Info(value="Sets the projectile range for the maid's ranged attack. Generally, this value is less than the search radius,\nand the maid will actively approach hostile entities until within range. Default is 16 blocks. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u8fdc\u7a0b\u653b\u51fb\u7684\u6295\u5c04\u7269\u5c04\u7a0b\u3002\u4e00\u822c\u8fd9\u4e2a\u6570\u503c\u4f1a\u5c0f\u4e8e\u641c\u7d22\u534a\u5f84\uff0c\u5973\u4ec6\u4f1a\u4e3b\u52a8\u63a5\u8fd1\u654c\u5bf9\u751f\u7269\uff0c\u76f4\u5230\u5c04\u7a0b\u8303\u56f4\u5185\u3002\u9ed8\u8ba4\u4e3a 16 \u683c\u3002\n")
        public Builder projectileRange(float projectileRange) {
            this.projectileRange = projectileRange;
            return this;
        }

        @Info(value="Sets the charge duration for the maid's ranged attack, in ticks. Generally, this is 20 ticks. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u8fdc\u7a0b\u653b\u51fb\u7684\u5145\u80fd\u65f6\u95f4\uff0c\u5355\u4f4d\u4e3a tick\u3002\u4e00\u822c\u662f 20 tick\u3002\n")
        public Builder chargeDurationTick(int chargeDurationTick) {
            this.chargeDurationTick = chargeDurationTick;
            return this;
        }

        @Info(value="Sets the walk speed for the maid when performing a ranged attack. Since ranged attacks require frequent movement,\nthis value can be slightly less than 0.6f. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u8fdc\u7a0b\u653b\u51fb\u65f6\u7684\u884c\u8d70\u901f\u5ea6\u3002\u56e0\u4e3a\u8fdc\u7a0b\u653b\u51fb\u8d70\u4f4d\u6bd4\u8f83\u9891\u7e41\uff0c\u6240\u4ee5\u8fd9\u4e2a\u6570\u503c\u53ef\u4ee5\u7565\u5c0f\u4e8e 0.6f\u3002\n")
        public Builder walkSpeed(float walkSpeed) {
            this.walkSpeed = walkSpeed;
            return this;
        }

        @Info(value="Sets the action to perform when the maid performs a ranged attack. Default is empty. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u6267\u884c\u8fdc\u7a0b\u653b\u51fb\u65f6\u7684\u884c\u4e3a\u3002\u9ed8\u8ba4\u4e3a\u7a7a\u3002\n")
        public Builder performRangedAttack(TriConsumer<EntityMaid, class_1309, Float> performRangedAttack) {
            this.performRangedAttack = performRangedAttack;
            return this;
        }
    }
}

