/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task.TaskBuilder;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidArriveAtBlockTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidMoveToPredicateBlockTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7893;
import org.jetbrains.annotations.Nullable;

public class WalkToBlockTaskJS
implements IMaidTask {
    private final Builder builder;

    public WalkToBlockTaskJS(Builder builder) {
        this.builder = builder;
    }

    @Override
    public class_2960 getUid() {
        return this.builder.id;
    }

    @Override
    public class_1799 getIcon() {
        return this.builder.icon;
    }

    @Override
    @Nullable
    public class_3414 getAmbientSound(EntityMaid maid) {
        if (this.builder.sound == null) {
            return SoundUtil.environmentSound(maid, InitSounds.MAID_IDLE, 0.5f);
        }
        return this.builder.sound;
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        MaidMoveToPredicateBlockTask moveToPredicateBlockTask = new MaidMoveToPredicateBlockTask(0.6f, this.builder.verticalSearchRange, this.builder.searchCondition, this.builder.blockPredicate);
        MaidArriveAtBlockTask arriveAtBlockTask = new MaidArriveAtBlockTask(this.builder.closeEnoughDist, this.builder.arriveAction);
        ArrayList tasks = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)moveToPredicateBlockTask)), Pair.of((Object)6, (Object)((Object)arriveAtBlockTask))});
        for (Pair pair : this.builder.brains) {
            tasks.add(Pair.of((Object)((Integer)pair.getFirst()), (Object)((class_7893)((BiFunction)pair.getSecond()).apply(this, maid))));
        }
        return tasks;
    }

    @Override
    public boolean isEnable(EntityMaid maid) {
        if (this.builder.enable == null) {
            return true;
        }
        return this.builder.enable.test(maid);
    }

    @Override
    public boolean isHidden(EntityMaid maid) {
        if (this.builder.isHidden == null) {
            return false;
        }
        return this.builder.isHidden.test(maid);
    }

    @Override
    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        if (this.builder.enableLookAndRandomWalk == null) {
            return true;
        }
        return this.builder.enableLookAndRandomWalk.test(maid);
    }

    @Override
    public boolean enableEating(EntityMaid maid) {
        if (this.builder.enableEating == null) {
            return true;
        }
        return this.builder.enableEating.test(maid);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getEnableConditionDesc(EntityMaid maid) {
        return this.builder.enableConditionDesc;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return this.builder.conditionDesc;
    }

    public static class Builder
    extends TaskBuilder<Builder, WalkToBlockTaskJS> {
        @Nullable
        private Predicate<EntityMaid> searchCondition = null;
        @Nullable
        private BiPredicate<EntityMaid, class_2338> blockPredicate = null;
        @Nullable
        private BiConsumer<EntityMaid, class_2338> arriveAction;
        private double closeEnoughDist = 2.0;
        private int verticalSearchRange = 2;

        public Builder(class_2960 id, class_1799 icon) {
            super(id, icon);
        }

        @Info(value="Must be set before searching for blocks. If not set, the search will not be performed.\nPlease search only when necessary to reduce performance overhead. <br>\n\u5fc5\u586b\u9879\u76ee\uff0c\u5426\u5219\u4e0d\u8fdb\u884c\u641c\u7d22\u3002\u5f00\u59cb\u8fdb\u884c\u641c\u7d22\u4e4b\u524d\u7684\u5224\u65ad\u6761\u4ef6\uff0c\u8bf7\u5728\u5fc5\u8981\u65f6\u5728\u8fdb\u884c\u641c\u7d22\uff0c\u51cf\u5c11\u6027\u80fd\u6d88\u8017\n")
        public Builder setSearchCondition(Predicate<EntityMaid> condition) {
            this.searchCondition = condition;
            return this;
        }

        @Info(value="Set the predicate for the block to be searched. If not set, the task will not search for blocks. <br>\n\u8bbe\u7f6e\u641c\u7d22\u7684\u65b9\u5757\u7684\u5224\u65ad\u6761\u4ef6\uff0c\u5982\u679c\u4e0d\u8bbe\u7f6e\uff0c\u5219\u4e0d\u4f1a\u8fdb\u884c\u65b9\u5757\u641c\u7d22\u3002\n")
        public Builder setBlockPredicate(BiPredicate<EntityMaid, class_2338> predicate) {
            this.blockPredicate = predicate;
            return this;
        }

        @Info(value="Set the action to be performed when the maid arrives at the block. If not set, no action will be performed. <br>\n\u8bbe\u7f6e\u5f53\u5973\u4ec6\u5230\u8fbe\u65b9\u5757\u65f6\u6267\u884c\u7684\u52a8\u4f5c\uff0c\u5982\u679c\u4e0d\u8bbe\u7f6e\uff0c\u5219\u4e0d\u4f1a\u6267\u884c\u4efb\u4f55\u52a8\u4f5c\u3002\n")
        public Builder setArriveAction(BiConsumer<EntityMaid, class_2338> action) {
            this.arriveAction = action;
            return this;
        }

        @Info(value="Set the distance at which the maid is considered close enough to the block. Default is 2 blocks. <br>\n\u8bbe\u7f6e\u5973\u4ec6\u5230\u8fbe\u65b9\u5757\u65f6\u7684\u8ddd\u79bb\uff0c\u4f4e\u4e8e\u8be5\u8ddd\u79bb\u5219\u8ba4\u4e3a\u5230\u8fbe\u3002\u9ed8\u8ba4\u4e3a 2 \u683c\u3002\n")
        public Builder setCloseEnoughDist(double dist) {
            this.closeEnoughDist = dist;
            return this;
        }

        @Info(value="Search range for the blocks. The search is limited to the maid's working area, so we can only customize the vertical height of the search. <br>\nBut this value should not be too large, otherwise traversing blocks will cause serious performance overhead. <br>\nDefault is 2, which means searching from -2 to 2 in the vertical direction. <br>\n\u641c\u7d22\u8303\u56f4\u4e3a\u5973\u4ec6\u7684\u5de5\u4f5c\u8303\u56f4\uff0c\u6211\u4eec\u53ea\u80fd\u81ea\u5b9a\u4e49\u641c\u7d22\u7684\u5782\u76f4\u9ad8\u5ea6\u3002 <br>\n\u6b64\u6570\u503c\u4e0d\u5b9c\u8fc7\u5927\uff0c\u5426\u5219\u904d\u5386\u65b9\u5757\u4f1a\u5e26\u6765\u4e25\u91cd\u7684\u6027\u80fd\u6d88\u8017\u3002\u9ed8\u8ba4\u4e3a 2\uff0c\u4e5f\u5c31\u662f\u641c\u7d22 -2 ~ 2 \u7684\u5782\u76f4\u8303\u56f4\u3002\n")
        public Builder setVerticalSearchRange(int range) {
            this.verticalSearchRange = range;
            return this;
        }
    }
}

