/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.patchouli;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class AltarRecipeComponent
implements IComponentProcessor {
    private static final String RECIPE_ID = "recipe_id";
    private static final String INPUT = "input";
    private static final String POWER_COST = "power_cost";
    private static final String OUTPUT_ITEM = "output_item";
    private static final String OUTPUT_ENTITY = "output_entity";
    private static final String OUTPUT_DESC = "output_desc";
    @Nullable
    private AltarRecipe recipe;

    public void setup(class_1937 level, IVariableProvider variables) {
        class_2960 recipeId = new class_2960(variables.get(RECIPE_ID).asString());
        List allAltarRecipes = level.method_8433().method_30027(InitRecipes.ALTAR_CRAFTING);
        for (AltarRecipe recipe : allAltarRecipes) {
            if (!recipe.method_8114().equals((Object)recipeId)) continue;
            this.recipe = recipe;
            return;
        }
        this.recipe = new AltarRecipe(new class_2960("touhou_little_maid", "empty"), class_1299.field_6052, null, 0.0f, class_1856.field_9017);
        TouhouLittleMaid.LOGGER.error("Altar recipe not found: {}", (Object)recipeId);
    }

    @Nullable
    public IVariable process(class_1937 level, String key) {
        if (key.startsWith(INPUT)) {
            int index = Integer.parseInt(key.substring(INPUT.length())) - 1;
            if (index < 0 || index >= this.recipe.method_8117().size()) {
                return IVariable.from((Object)class_1799.field_8037);
            }
            class_1856 ingredient = (class_1856)this.recipe.method_8117().get(index);
            class_1799[] stacks = ingredient.method_8105();
            if (stacks.length == 0) {
                return IVariable.from((Object)class_1799.field_8037);
            }
            ArrayList stackNames = Lists.newArrayList();
            for (class_1799 stack : stacks) {
                class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
                if (itemId == class_7923.field_41178.method_10137()) continue;
                stackNames.add(itemId.toString());
            }
            return IVariable.wrap((String)StringUtils.join((Iterable)stackNames, (String)","));
        }
        switch (key) {
            case "power_cost": {
                float powerCost = this.recipe.getPowerCost();
                return IVariable.wrap((String)String.format("x%.2f", Float.valueOf(powerCost)));
            }
            case "output_item": {
                return IVariable.from((Object)this.recipe.method_8110(level.method_30349()));
            }
            case "output_desc": {
                String langKey;
                String namespace = this.recipe.method_8114().method_12836().toLowerCase(Locale.US);
                if (this.recipe.isItemCraft()) {
                    langKey = String.format("jei.%s.altar_craft.%s.result", namespace, "item_craft");
                } else {
                    Path path = Paths.get(this.recipe.method_8114().method_12832().toLowerCase(Locale.US), new String[0]);
                    langKey = String.format("jei.%s.altar_craft.%s.result", namespace, path.getFileName());
                }
                return IVariable.wrap((String)class_1074.method_4662((String)langKey, (Object[])new Object[0]));
            }
            case "output_entity": {
                class_2960 entityId;
                Object entityType = this.recipe.getEntityType();
                if (entityType.equals(InitEntities.BOX)) {
                    entityType = InitEntities.MAID;
                }
                if ((entityId = class_7923.field_41177.method_10221(entityType)) != class_7923.field_41177.method_10137()) {
                    return IVariable.wrap((String)entityId.toString());
                }
                return IVariable.wrap((String)"minecraft:item");
            }
        }
        return null;
    }
}

