/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datapack.resources;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.datapack.BoardStateData;
import com.github.tartaricacid.touhoulittlemaid.datapack.pojo.BoardStateRecord;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_7367;

public class BoardStateDataReloadListener
implements class_4013,
IdentifiableResourceReloadListener {
    private static final class_2960 CHESS_PATH = new class_2960("touhou_little_maid", "board_states/chess.json");
    private static final class_2960 XIANGQI_PATH = new class_2960("touhou_little_maid", "board_states/xiangqi.json");
    private static final class_2960 GOMOKU_PATH = new class_2960("touhou_little_maid", "board_states/gomoku.json");
    private static final Gson GSON = new Gson();
    private static final class_2960 ID = new class_2960("touhou_little_maid", "board_states_reload");

    public void method_14491(class_3300 resourceManager) {
        BoardStateData.clear();
        resourceManager.method_29213().forEach(packResources -> {
            BoardStateDataReloadListener.readData(packResources, CHESS_PATH, BoardStateData::addChessRecords);
            BoardStateDataReloadListener.readData(packResources, XIANGQI_PATH, BoardStateData::addXiangqiRecords);
            BoardStateDataReloadListener.readData(packResources, GOMOKU_PATH, BoardStateData::addGomokuRecords);
        });
    }

    private static void readData(class_3262 packResources, class_2960 path, Consumer<List<BoardStateRecord>> adder) {
        class_7367 resource = packResources.method_14405(class_3264.field_14190, path);
        if (resource == null) {
            return;
        }
        try (InputStream inputStream = (InputStream)resource.get();
             InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            List records = (List)GSON.fromJson((Reader)reader, new TypeToken<List<BoardStateRecord>>(){}.getType());
            if (records != null && !records.isEmpty()) {
                adder.accept(records);
            }
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Failed to load board state data from {}", (Object)path, (Object)e);
        }
    }

    public class_2960 getFabricId() {
        return ID;
    }
}

