/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.debug.target;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.debug.target.DebugTarget;
import com.github.tartaricacid.touhoulittlemaid.debug.target.DefaultTargets;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5996;
import net.minecraft.server.MinecraftServer;

@class_5996
public class DebugMaidManager {
    public static ConcurrentHashMap<UUID, Set<UUID>> PLAYER_DEBUGGING_MAID = new ConcurrentHashMap();
    public static ConcurrentHashMap<UUID, Set<UUID>> MAID_DEBUGGING_PLAYER = new ConcurrentHashMap();
    public static List<Function<EntityMaid, List<DebugTarget>>> DEBUG_TARGETS = new ArrayList<Function<EntityMaid, List<DebugTarget>>>();

    public static void init() {
        DEBUG_TARGETS.addAll(DefaultTargets.getDefaultTargets());
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            DEBUG_TARGETS.addAll(littleMaid.getMaidDebugTargets());
        }
    }

    public static List<DebugTarget> getDebugTargets(EntityMaid maid) {
        return DEBUG_TARGETS.stream().flatMap(f -> ((List)f.apply(maid)).stream()).toList();
    }

    public static List<class_3222> getDebuggingPlayer(EntityMaid maid) {
        Set<UUID> playerId = MAID_DEBUGGING_PLAYER.get(maid.method_5667());
        if (playerId == null) {
            return List.of();
        }
        MinecraftServer server = maid.field_6002.method_8503();
        if (server == null) {
            return List.of();
        }
        return playerId.stream().map(uuid -> server.method_3760().method_14602(uuid)).filter(Objects::nonNull).toList();
    }

    public static List<EntityMaid> getDebuggingMaid(class_3222 player) {
        Set<UUID> maidId = PLAYER_DEBUGGING_MAID.get(player.method_5667());
        if (maidId == null) {
            return List.of();
        }
        return maidId.stream().map(uuid -> player.method_51469().method_14190(uuid)).filter(Objects::nonNull).filter(EntityMaid.class::isInstance).map(EntityMaid.class::cast).toList();
    }

    public static void setDebuggingMaid(class_3222 player, EntityMaid maid) {
        DebugMaidManager.removeDebuggingMaid(player, maid);
        PLAYER_DEBUGGING_MAID.computeIfAbsent(player.method_5667(), k -> new HashSet()).add(maid.method_5667());
        MAID_DEBUGGING_PLAYER.computeIfAbsent(maid.method_5667(), k -> new HashSet()).add(player.method_5667());
    }

    public static void removeDebuggingMaid(class_3222 player, EntityMaid maid) {
        if (PLAYER_DEBUGGING_MAID.containsKey(player.method_5667())) {
            PLAYER_DEBUGGING_MAID.get(player.method_5667()).remove(maid.method_5667());
        }
        if (MAID_DEBUGGING_PLAYER.containsKey(maid.method_5667())) {
            MAID_DEBUGGING_PLAYER.get(maid.method_5667()).remove(player.method_5667());
        }
    }

    public static void triggerDebuggingMaid(class_3222 player, EntityMaid maid) {
        if (PLAYER_DEBUGGING_MAID.containsKey(player.method_5667()) && PLAYER_DEBUGGING_MAID.get(player.method_5667()).contains(maid.method_5667())) {
            DebugMaidManager.removeDebuggingMaid(player, maid);
            player.method_43496((class_2561)class_2561.method_43471((String)"debug.touhou_little_maid.debug_stick.show_path_finder.disable"));
        } else {
            DebugMaidManager.setDebuggingMaid(player, maid);
            player.method_43496((class_2561)class_2561.method_43471((String)"debug.touhou_little_maid.debug_stick.show_path_finder.enable"));
        }
    }
}

