/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.backpack;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.InvWrapper;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.FurnaceBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.FurnaceBackpackContainer;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_4587;
import net.minecraft.class_5599;
import net.minecraft.class_583;

public class FurnaceBackpack
extends IMaidBackpack {
    public static final class_2960 ID = new class_2960("touhou_little_maid", "furnace_backpack");

    @Override
    public void onPutOn(class_1799 stack, class_1657 player, EntityMaid maid) {
    }

    @Override
    public void onTakeOff(class_1799 stack, class_1657 player, EntityMaid maid) {
        IBackpackData backpackData = maid.getBackpackData();
        if (backpackData instanceof FurnaceBackpackData) {
            FurnaceBackpackData furnaceBackpackData = (FurnaceBackpackData)backpackData;
            InvWrapper inv = new InvWrapper((class_1263)furnaceBackpackData);
            ItemsUtil.dropEntityItems((class_1297)maid, inv);
        }
        this.dropRelativeItems(stack, maid);
    }

    @Override
    public void onSpawnTombstone(EntityMaid maid, EntityTombstone tombstone) {
        IBackpackData backpackData = maid.getBackpackData();
        if (backpackData instanceof FurnaceBackpackData) {
            FurnaceBackpackData furnaceBackpackData = (FurnaceBackpackData)backpackData;
            InvWrapper inv = new InvWrapper((class_1263)furnaceBackpackData);
            for (int i = 0; i < inv.getSlots(); ++i) {
                int size = inv.getSlotLimit(i);
                tombstone.insertItem(inv.extractItem(i, size, false));
            }
        }
    }

    @Override
    public class_3908 getGuiProvider(final int entityId) {
        return new ExtendedScreenHandlerFactory(){

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                buf.writeInt(entityId);
            }

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Maid Furnace Container");
            }

            public AbstractMaidContainer createMenu(int index, class_1661 playerInventory, class_1657 player) {
                return new FurnaceBackpackContainer(index, playerInventory, entityId);
            }

            public boolean shouldCloseCurrentScreen() {
                return false;
            }
        };
    }

    @Override
    public boolean hasBackpackData() {
        return true;
    }

    @Override
    @Nullable
    public IBackpackData getBackpackData(EntityMaid maid) {
        return new FurnaceBackpackData(maid);
    }

    @Override
    public int getAvailableMaxContainerIndex() {
        return 18;
    }

    @Override
    @Nullable
    @Environment(value=EnvType.CLIENT)
    public class_583<EntityMaid> getBackpackModel(class_5599 modelSet) {
        return BedrockModelLoader.getModel(BedrockModelLoader.FURNACE_BACKPACK);
    }

    @Override
    @Nullable
    @Environment(value=EnvType.CLIENT)
    public class_2960 getBackpackTexture() {
        return new class_2960("touhou_little_maid", "textures/bedrock/entity/backpack/furnace_backpack.png");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void offsetBackpackItem(class_4587 poseStack) {
        poseStack.method_22904(0.0, 0.625, 0.25);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public class_1792 getItem() {
        return InitItems.FURNACE_BACKPACK;
    }
}

