/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleDataCollection;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.EmojiChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.ImageChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.ProgressChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.TextChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.WaitingChatBubbleData;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2941;
import net.minecraft.class_2960;

public class ChatBubbleRegister {
    public static Map<class_2960, IChatBubbleData.ChatSerializer> CODEC_MAP = Maps.newHashMap();
    public static final class_2941<ChatBubbleDataCollection> INSTANCE = new class_2941<ChatBubbleDataCollection>(){

        public void write(class_2540 buf, ChatBubbleDataCollection data) {
            buf.method_10804(Math.min(5, data.size()));
            int i = 0;
            LongBidirectionalIterator longBidirectionalIterator = data.keySet().iterator();
            while (longBidirectionalIterator.hasNext()) {
                long key = (Long)longBidirectionalIterator.next();
                if (i < 5) {
                    IChatBubbleData bubbleData = data.get(key);
                    buf.writeLong(key);
                    class_2960 id = bubbleData.id();
                    buf.method_10812(id);
                    CODEC_MAP.get(id).writeToBuff(buf, bubbleData);
                }
                ++i;
            }
        }

        public ChatBubbleDataCollection read(class_2540 buf) {
            ChatBubbleDataCollection map = new ChatBubbleDataCollection((Long2ObjectSortedMap<IChatBubbleData>)new Long2ObjectAVLTreeMap());
            int size = buf.method_10816();
            for (int i = 0; i < size; ++i) {
                long key = buf.readLong();
                class_2960 id = buf.method_10810();
                IChatBubbleData bubbleData = CODEC_MAP.get(id).readFromBuff(buf);
                map.put(key, bubbleData);
            }
            return map;
        }

        public ChatBubbleDataCollection copy(ChatBubbleDataCollection value) {
            class_2540 byteBuf = new class_2540(Unpooled.buffer());
            this.write(byteBuf, value);
            return this.read(byteBuf);
        }
    };

    public static void init() {
        ChatBubbleRegister register = new ChatBubbleRegister();
        register.register(TextChatBubbleData.ID, new TextChatBubbleData.TextChatSerializer());
        register.register(ImageChatBubbleData.ID, new ImageChatBubbleData.ImageChatSerializer());
        register.register(WaitingChatBubbleData.ID, new WaitingChatBubbleData.WaitingChatSerializer());
        register.register(ProgressChatBubbleData.ID, new ProgressChatBubbleData.ProgressChatSerializer());
        register.register(EmojiChatBubbleData.ID, new EmojiChatBubbleData.EmojiChatSerializer());
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.registerChatBubble(register);
        }
        CODEC_MAP = ImmutableMap.copyOf(CODEC_MAP);
    }

    public void register(class_2960 id, IChatBubbleData.ChatSerializer serializer) {
        if (CODEC_MAP.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate codec id: " + String.valueOf(id));
        }
        CODEC_MAP.put(id, serializer);
    }
}

