/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.monster;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.goal.FairyAttackGoal;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.goal.FairyNearestAttackableTargetGoal;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.FairyType;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.IHasPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuShoot;
import com.github.tartaricacid.touhoulittlemaid.init.InitPoi;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import javax.annotation.Nullable;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1331;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1370;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1432;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public class EntityFairy
extends class_1588
implements class_1603,
class_1432,
IHasPowerPoint {
    public static final class_1299<EntityFairy> TYPE = class_1299.class_1300.method_5903(EntityFairy::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 1.5f).method_27299(10).method_5905("fairy");
    public static final String RICK = "rick";
    private static final String FAIRY_TYPE_TAG_NAME = "FairyType";
    private static final class_2940<Integer> FAIRY_TYPE = class_2945.method_12791(EntityFairy.class, (class_2941)class_2943.field_13327);
    private static final double AIMED_SHOT_PROBABILITY = 0.9;

    protected EntityFairy(class_1299<? extends class_1588> type, class_1937 worldIn) {
        super(type, worldIn);
        this.field_6207 = new class_1331((class_1308)this, 15, true);
    }

    public EntityFairy(class_1937 worldIn) {
        this(TYPE, worldIn);
    }

    public static class_5132.class_5133 createFairyAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23721, 1.5).method_26868(class_5134.field_23724, 1.0).method_26868(class_5134.field_23720, 0.4);
    }

    public static boolean checkFairySpawnRules(class_1299<EntityFairy> entityType, class_5425 levelAccessor, class_3730 spawnType, class_2338 pos, class_5819 randomSource) {
        if (class_1588.method_20680(entityType, (class_5425)levelAccessor, (class_3730)spawnType, (class_2338)pos, (class_5819)randomSource) && levelAccessor instanceof class_3218) {
            class_3218 level = (class_3218)levelAccessor;
            int scarecrowRange = (Integer)MiscConfig.SCARECROW_RANGE.get();
            long findCount = level.method_19494().method_22383(type -> ((class_4158)type.comp_349()).equals((Object)InitPoi.SCARECROW), pos, scarecrowRange, class_4153.class_4155.field_18489).count();
            return findCount <= 0L;
        }
        return false;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new FairyAttackGoal(this, 6.0, 1.0));
        this.field_6201.method_6277(2, (class_1352)new class_1370((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, EntityMaid.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, new FairyNearestAttackableTargetGoal(this));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FAIRY_TYPE, (Object)FairyType.BLACK.ordinal());
    }

    @Override
    public int getPowerPoint() {
        return (int)((Double)MiscConfig.MAID_FAIRY_POWER_POINT.get() * 100.0);
    }

    protected void method_6108() {
        super.method_6108();
        this.dropPowerPoint((class_1309)this);
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 source) {
        return false;
    }

    public void method_7105(class_1309 target, float distanceFactor) {
        float damageBase = 1.0f;
        class_1267 difficulty = target.field_6002.method_8407();
        switch (difficulty) {
            case field_5802: {
                damageBase = 1.5f;
                break;
            }
            case field_5807: {
                damageBase = 2.0f;
            }
        }
        if ((double)this.field_5974.method_43057() <= 0.9) {
            DanmakuShoot.create().setWorld(this.field_6002).setThrower((class_1309)this).setTarget(target).setRandomColor().setRandomType().setDamage(distanceFactor + damageBase).setGravity(0.0f).setVelocity(0.2f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).aimedShot();
        } else {
            DanmakuShoot.create().setWorld(this.field_6002).setThrower((class_1309)this).setTarget(target).setRandomColor().setRandomType().setDamage(distanceFactor + damageBase + 0.5f).setGravity(0.0f).setVelocity(0.2f * (distanceFactor + 1.0f)).setInaccuracy(0.2f).setFanNum(3).setYawTotal(0.5235987755982988).fanShapedShot();
        }
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        class_1407 navigator = new class_1407((class_1308)this, worldIn);
        navigator.method_6332(false);
        navigator.method_6354(true);
        navigator.method_6331(true);
        return navigator;
    }

    @Nullable
    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, @Nullable class_1315 spawnDataIn, @Nullable class_2487 tag) {
        this.setFairyTypeOrdinal(this.field_5974.method_43048(FairyType.values().length));
        if (this.field_5974.method_43048(20) == 0) {
            this.method_5665((class_2561)class_2561.method_43470((String)RICK));
            this.method_5880(true);
        }
        return super.method_5943(worldIn, difficultyIn, reason, spawnDataIn, tag);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569(FAIRY_TYPE_TAG_NAME, this.getFairyTypeOrdinal());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10573(FAIRY_TYPE_TAG_NAME, 3)) {
            this.setFairyTypeOrdinal(compound.method_10550(FAIRY_TYPE_TAG_NAME));
        }
    }

    public int getFairyTypeOrdinal() {
        return (Integer)this.field_6011.method_12789(FAIRY_TYPE);
    }

    public void setFairyTypeOrdinal(int ordinal) {
        this.field_6011.method_12778(FAIRY_TYPE, (Object)ordinal);
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    @Nullable
    protected class_3414 method_5994() {
        return InitSounds.FAIRY_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 pDamageSource) {
        return InitSounds.FAIRY_HURT;
    }

    protected class_3414 method_6002() {
        return InitSounds.FAIRY_DEATH;
    }
}

