/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.TeleportHelper;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_4215;

public final class SchedulePos {
    private static final int MAX_TELEPORT_ATTEMPTS_TIMES = 10;
    private class_2338 workPos;
    private class_2338 idlePos;
    private class_2338 sleepPos;
    private class_2960 dimension;
    private boolean configured = false;

    public SchedulePos(class_2338 workPos, class_2338 idlePos, class_2338 sleepPos, class_2960 dimension) {
        this.workPos = workPos;
        this.idlePos = idlePos;
        this.sleepPos = sleepPos;
        this.dimension = dimension;
    }

    public SchedulePos(class_2338 workPos, class_2338 idlePos, class_2960 dimension) {
        this(workPos, idlePos, idlePos, dimension);
    }

    public SchedulePos(class_2338 workPos, class_2960 dimension) {
        this(workPos, workPos, dimension);
    }

    public void setWorkPos(class_2338 workPos) {
        this.workPos = workPos;
    }

    public void setIdlePos(class_2338 idlePos) {
        this.idlePos = idlePos;
    }

    public void setSleepPos(class_2338 sleepPos) {
        this.sleepPos = sleepPos;
    }

    public void setDimension(class_2960 dimension) {
        this.dimension = dimension;
    }

    public void tick(EntityMaid maid) {
        if (maid.field_6012 % 40 == 0) {
            int minTeleportDistance;
            this.restrictTo(maid);
            if (maid.method_18411()) {
                return;
            }
            if (!maid.canBrainMoving()) {
                return;
            }
            double distanceSqr = maid.method_18412().method_10262((class_2382)maid.method_24515());
            if (distanceSqr > (double)((minTeleportDistance = (int)maid.method_18413() + 4) * minTeleportDistance) && !this.sameWithRestrictCenter(maid)) {
                this.teleport(maid);
            } else {
                class_4215.method_24561((class_1309)maid, (class_2338)maid.method_18412(), (float)0.7f, (int)3);
            }
        }
    }

    public void save(class_2487 compound) {
        class_2487 data = new class_2487();
        data.method_10566("Work", (class_2520)class_2512.method_10692((class_2338)this.workPos));
        data.method_10566("Idle", (class_2520)class_2512.method_10692((class_2338)this.idlePos));
        data.method_10566("Sleep", (class_2520)class_2512.method_10692((class_2338)this.sleepPos));
        data.method_10582("Dimension", this.dimension.toString());
        data.method_10556("Configured", this.configured);
        compound.method_10566("MaidSchedulePos", (class_2520)data);
    }

    public void load(class_2487 compound, EntityMaid maid) {
        if (compound.method_10573("MaidSchedulePos", 10)) {
            class_2487 data = compound.method_10562("MaidSchedulePos");
            this.workPos = class_2512.method_10691((class_2487)data.method_10562("Work"));
            this.idlePos = class_2512.method_10691((class_2487)data.method_10562("Idle"));
            this.sleepPos = class_2512.method_10691((class_2487)data.method_10562("Sleep"));
            this.dimension = new class_2960(data.method_10558("Dimension"));
            this.configured = data.method_10577("Configured");
            this.restrictTo(maid);
        }
    }

    public void restrictTo(EntityMaid maid) {
        if (!maid.isHomeModeEnable()) {
            return;
        }
        class_4168 activity = maid.getScheduleDetail();
        if (activity == class_4168.field_18596) {
            maid.method_18408(this.workPos, (Integer)MaidConfig.MAID_WORK_RANGE.get());
            return;
        }
        if (activity == class_4168.field_18595) {
            maid.method_18408(this.idlePos, (Integer)MaidConfig.MAID_IDLE_RANGE.get());
            return;
        }
        if (activity == class_4168.field_18597) {
            maid.method_18408(this.sleepPos, (Integer)MaidConfig.MAID_SLEEP_RANGE.get());
        }
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public class_2338 getWorkPos() {
        return this.workPos;
    }

    public class_2338 getIdlePos() {
        return this.idlePos;
    }

    public class_2338 getSleepPos() {
        return this.sleepPos;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public class_2960 getDimension() {
        return this.dimension;
    }

    public void clear(EntityMaid maid) {
        this.idlePos = this.workPos;
        this.sleepPos = this.workPos;
        this.configured = false;
        this.dimension = maid.field_6002.method_27983().method_29177();
        this.restrictTo(maid);
    }

    public void setHomeModeEnable(EntityMaid maid, class_2338 pos) {
        if (!this.configured) {
            this.workPos = pos;
            this.idlePos = pos;
            this.sleepPos = pos;
            this.dimension = maid.field_6002.method_27983().method_29177();
        }
        this.restrictTo(maid);
    }

    @Nullable
    public class_2338 getNearestPos(EntityMaid maid) {
        if (this.configured) {
            class_2338 pos = this.workPos;
            double workDistance = maid.method_24515().method_10262((class_2382)this.workPos);
            double idleDistance = maid.method_24515().method_10262((class_2382)this.idlePos);
            double sleepDistance = maid.method_24515().method_10262((class_2382)this.sleepPos);
            if (workDistance > idleDistance) {
                pos = this.idlePos;
                workDistance = idleDistance;
            }
            if (workDistance > sleepDistance) {
                pos = this.sleepPos;
            }
            return pos;
        }
        return null;
    }

    private boolean sameWithRestrictCenter(EntityMaid maid) {
        class_2338 restrictCenter = maid.method_18412();
        return maid.method_18868().method_18904(class_4140.field_18445).filter(walkTarget -> walkTarget.method_19094().method_18989().equals((Object)restrictCenter)).isPresent();
    }

    private void teleport(EntityMaid maid) {
        for (int i = 0; i < 10; ++i) {
            if (!TeleportHelper.teleportToRestrictCenter(maid)) continue;
            return;
        }
    }
}

