/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.projectile;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidFishedEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskFishing;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1676;
import net.minecraft.class_173;
import net.minecraft.class_1787;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class MaidFishingHook
extends class_1676 {
    public static final class_1299<MaidFishingHook> TYPE = class_1299.class_1300.method_5903(MaidFishingHook::new, (class_1311)class_1311.field_17715).method_5904().method_5901().method_17687(0.25f, 0.25f).method_27299(4).method_27300(5).method_5905("fishing_hook");
    protected static final class_2940<Boolean> DATA_BITING = class_2945.method_12791(MaidFishingHook.class, (class_2941)class_2943.field_13323);
    protected static final int MAX_OUT_OF_WATER_TIME = 10;
    protected final class_5819 syncronizedRandom = class_5819.method_43047();
    protected final int luck;
    protected final int lureSpeed;
    protected boolean biting;
    protected int nibble;
    protected int timeUntilLured;
    protected int timeUntilHooked;
    protected int outOfWaterTime;
    protected int life;
    protected float fishAngle;
    protected boolean openWater = true;
    protected FishHookState currentState = FishHookState.FLYING;

    protected MaidFishingHook(class_1299<? extends MaidFishingHook> entityType, class_1937 level, int luck, int lureSpeed) {
        super(entityType, level);
        this.field_5985 = true;
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    public MaidFishingHook(class_1299<MaidFishingHook> entityType, class_1937 level) {
        this(entityType, level, 0, 0);
    }

    public MaidFishingHook(EntityMaid maid, class_1937 level, int luck, int lureSpeed, class_243 pos) {
        this(TYPE, level, luck, lureSpeed);
        this.method_7432((class_1297)maid);
        this.method_29495(pos);
    }

    protected void method_5693() {
        this.field_6011.method_12784(DATA_BITING, (Object)false);
    }

    public void method_5674(class_2940<?> key) {
        if (DATA_BITING.equals(key)) {
            this.biting = (Boolean)this.method_5841().method_12789(DATA_BITING);
            if (this.biting) {
                this.method_18800(this.method_18798().field_1352, -0.4 * (double)class_3532.method_15344((class_5819)this.syncronizedRandom, (float)0.6f, (float)1.0f), this.method_18798().field_1350);
            }
        }
        super.method_5674(key);
    }

    public boolean method_5640(double distance) {
        return distance < 4096.0;
    }

    public void method_5759(double x, double y, double z, float yRot, float xRot, int lerpSteps, boolean teleport) {
    }

    public void method_5773() {
        this.syncronizedRandom.method_43052(this.method_5667().getLeastSignificantBits() ^ this.field_6002.method_8510());
        super.method_5773();
        EntityMaid maid = this.getMaidOwner();
        if (maid == null) {
            this.method_31472();
        } else if (this.field_6002.field_9236 || !this.shouldStopFishing(maid)) {
            if (this.lifeTick()) {
                return;
            }
            maid.method_5988().method_35111((class_1297)this);
            this.fishingTick();
        }
    }

    protected boolean lifeTick() {
        if (this.method_24828()) {
            ++this.life;
            if (this.life >= 100) {
                this.method_31472();
                return true;
            }
        } else {
            this.life = 0;
        }
        return false;
    }

    protected void fishingTick() {
        boolean onWaterSurface;
        class_2338 blockPos = this.method_24515();
        class_3610 fluidState = this.field_6002.method_8316(blockPos);
        float fluidHeight = this.getFluidHeight(fluidState, blockPos);
        boolean bl = onWaterSurface = fluidHeight > 0.0f;
        if (this.currentState == FishHookState.FLYING) {
            if (onWaterSurface) {
                this.waterSurfaceTick();
                return;
            }
        } else if (this.currentState == FishHookState.BOBBING) {
            this.bobbingTick(blockPos, fluidHeight);
            this.checkOpenWater(blockPos);
            if (onWaterSurface) {
                this.bitingTick(blockPos);
            } else {
                this.outOfWaterTime = Math.min(10, this.outOfWaterTime + 1);
            }
        }
        this.fallTick(fluidState);
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_26962();
        if (this.currentState == FishHookState.FLYING && (this.method_24828() || this.field_5976)) {
            this.method_18799(class_243.field_1353);
        }
        this.method_18799(this.method_18798().method_1021(0.92));
        this.method_23311();
    }

    protected void fallTick(class_3610 fluidState) {
        if (!fluidState.method_15767(class_3486.field_15517)) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
        }
    }

    protected void bitingTick(class_2338 blockPos) {
        this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
        if (this.biting) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.1 * (double)this.syncronizedRandom.method_43057() * (double)this.syncronizedRandom.method_43057(), 0.0));
        }
        if (!this.field_6002.field_9236) {
            this.catchingFish(blockPos, (class_3218)this.field_6002);
        }
    }

    protected void checkOpenWater(class_2338 blockPos) {
        this.openWater = this.nibble <= 0 && this.timeUntilHooked <= 0 ? true : this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater(blockPos);
    }

    protected float getFluidHeight(class_3610 fluidState, class_2338 blockPos) {
        float fluidHeight = 0.0f;
        if (fluidState.method_15767(class_3486.field_15517)) {
            fluidHeight = fluidState.method_15763((class_1922)this.method_37908(), blockPos);
        }
        return fluidHeight;
    }

    protected void waterSurfaceTick() {
        this.method_18799(this.method_18798().method_18805(0.3, 0.2, 0.3));
        this.currentState = FishHookState.BOBBING;
    }

    protected void bobbingTick(class_2338 blockPos, float fluidHeight) {
        class_243 movement = this.method_18798();
        double bobbingY = this.method_23318() + movement.field_1351 - (double)blockPos.method_10264() - (double)fluidHeight;
        if (Math.abs(bobbingY) < 0.01) {
            bobbingY += Math.signum(bobbingY) * 0.1;
        }
        this.method_18800(movement.field_1352 * 0.9, movement.field_1351 - bobbingY * (double)this.field_5974.method_43057() * 0.2, movement.field_1350 * 0.9);
    }

    protected void catchingFish(class_2338 pos, class_3218 level) {
        int time = 1;
        class_2338 abovePos = pos.method_10084();
        if (this.field_5974.method_43057() < 0.25f && level.method_8520(abovePos)) {
            ++time;
        }
        if (this.field_5974.method_43057() < 0.5f && !level.method_8311(abovePos)) {
            --time;
        }
        if (this.nibble > 0) {
            --this.nibble;
            this.onNibble(level);
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= time;
            if (this.timeUntilHooked > 0) {
                this.fishAngle += (float)this.field_5974.method_43385(0.0, 9.188);
                float fishAngleRad = this.fishAngle * ((float)Math.PI / 180);
                float sin = class_3532.method_15374((float)fishAngleRad);
                float cos = class_3532.method_15362((float)fishAngleRad);
                double x = this.method_23317() + (double)(sin * (float)this.timeUntilHooked) * 0.1;
                double y = (double)class_3532.method_15357((double)this.method_23318()) + 1.0;
                double z = this.method_23321() + (double)(cos * (float)this.timeUntilHooked) * 0.1;
                class_2680 blockState = level.method_8320(class_2338.method_49637((double)x, (double)(y - 1.0), (double)z));
                this.spawnFishingParticle(level, blockState, x, y, z, sin, cos);
            } else {
                this.spawnNibbleParticle(level);
                this.nibble = class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)40);
                this.method_5841().method_12778(DATA_BITING, (Object)true);
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= time;
            float probability = 0.15f;
            if (this.timeUntilLured < 20) {
                probability += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                probability += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                probability += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.field_5974.method_43057() < probability) {
                float randomRot = class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float randomNum = class_3532.method_15344((class_5819)this.field_5974, (float)25.0f, (float)60.0f);
                double x = this.method_23317() + (double)(class_3532.method_15374((float)randomRot) * randomNum) * 0.1;
                double y = (double)class_3532.method_15357((double)this.method_23318()) + 1.0;
                double z = this.method_23321() + (double)(class_3532.method_15362((float)randomRot) * randomNum) * 0.1;
                class_2680 blockState = level.method_8320(class_2338.method_49637((double)x, (double)(y - 1.0), (double)z));
                this.spawnSplashParticle(level, blockState, x, y, z);
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = class_3532.method_15344((class_5819)this.field_5974, (float)0.0f, (float)360.0f);
                this.timeUntilHooked = class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)80);
            }
        } else {
            this.timeUntilLured = class_3532.method_15395((class_5819)this.field_5974, (int)100, (int)600);
            this.timeUntilLured -= this.lureSpeed;
        }
    }

    protected void spawnSplashParticle(class_3218 level, class_2680 blockState, double x, double y, double z) {
        if (blockState.method_27852(class_2246.field_10382)) {
            level.method_14199((class_2394)class_2398.field_11202, x, y, z, 2 + this.field_5974.method_43048(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
        }
    }

    protected void spawnNibbleParticle(class_3218 level) {
        double yOffset = this.method_23318() + 0.5;
        float bbWidth = this.method_17681();
        this.method_5783(class_3417.field_14660, 0.25f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.4f);
        level.method_14199((class_2394)class_2398.field_11247, this.method_23317(), yOffset, this.method_23321(), (int)(1.0f + bbWidth * 20.0f), (double)bbWidth, 0.0, (double)bbWidth, (double)0.2f);
        level.method_14199((class_2394)class_2398.field_11244, this.method_23317(), yOffset, this.method_23321(), (int)(1.0f + bbWidth * 20.0f), (double)bbWidth, 0.0, (double)bbWidth, (double)0.2f);
    }

    protected void spawnFishingParticle(class_3218 level, class_2680 blockState, double x, double y, double z, float sin, float cos) {
        if (blockState.method_27852(class_2246.field_10382)) {
            if (this.field_5974.method_43057() < 0.15f) {
                level.method_14199((class_2394)class_2398.field_11247, x, y - 0.1, z, 1, (double)sin, 0.1, (double)cos, 0.0);
            }
            float sinOffset = sin * 0.04f;
            float cosOffset = cos * 0.04f;
            level.method_14199((class_2394)class_2398.field_11244, x, y, z, 0, (double)cosOffset, 0.01, (double)(-sinOffset), 1.0);
            level.method_14199((class_2394)class_2398.field_11244, x, y, z, 0, (double)(-cosOffset), 0.01, (double)sinOffset, 1.0);
        }
    }

    protected void onNibble(class_3218 level) {
        EntityMaid maid = this.getMaidOwner();
        int retrieveTime = class_3532.method_15395((class_5819)this.field_5974, (int)2, (int)10);
        if (this.nibble <= retrieveTime && maid != null) {
            class_1799 rodItem = maid.method_6047();
            int rodDamage = this.retrieve(rodItem);
            this.hurtRod(maid, rodItem, rodDamage);
            maid.method_6104(class_1268.field_5808);
            level.method_43128(null, maid.method_23317(), maid.method_23318(), maid.method_23321(), class_3417.field_15093, class_3419.field_15254, 1.0f, 0.4f / (level.method_8409().method_43057() * 0.4f + 0.8f));
        }
    }

    public int retrieve(class_1799 stack) {
        EntityMaid maid = this.getMaidOwner();
        if (!this.field_6002.field_9236 && maid != null && !this.shouldStopFishing(maid)) {
            MaidFishedEvent event = null;
            MinecraftServer server = this.field_6002.method_8503();
            int rodDamage = 0;
            if (this.nibble > 0 && server != null) {
                class_3218 serverLevel = (class_3218)this.field_6002;
                class_8567 lootParams = new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1229, (Object)stack).method_51874(class_181.field_1226, (Object)this).method_51871((float)this.luck + maid.getLuck()).method_51875(class_173.field_1176);
                List<class_1799> randomItems = this.getLoot(server, lootParams);
                this.addExtraLoot(randomItems);
                event = new MaidFishedEvent(randomItems, this.method_24828() ? 2 : 1, this);
                ((MaidFishedEvent.Callback)MaidFishedEvent.CALLBACK.invoker()).post(event);
                if (event.isCanceled()) {
                    this.method_31472();
                    return event.getRodDamage();
                }
                this.spawnLoot(randomItems, maid);
                this.afterFishing();
                rodDamage = 1;
            }
            if (this.method_24828()) {
                rodDamage = 2;
            }
            this.method_31472();
            return event == null ? rodDamage : event.getRodDamage();
        }
        return 0;
    }

    @NotNull
    protected List<class_1799> getLoot(MinecraftServer server, class_8567 lootParams) {
        class_52 lootTable = server.method_3857().getLootTable(class_39.field_353);
        return lootTable.method_51878(lootParams);
    }

    protected void spawnLoot(List<class_1799> randomItems, EntityMaid maid) {
        class_1309 class_13092;
        EntityMaid maidOwner = this.getMaidOwner();
        class_3222 serverPlayer = null;
        if (maidOwner != null && (class_13092 = maidOwner.method_35057()) instanceof class_3222) {
            class_3222 serverPlayerIn;
            serverPlayer = serverPlayerIn = (class_3222)class_13092;
        }
        for (class_1799 result : randomItems) {
            if (serverPlayer != null && result.method_31574(class_1802.field_8598)) {
                InitTrigger.MAID_EVENT.trigger(serverPlayer, "maid_fishing_enchanted_book");
            }
            class_1542 itemEntity = new class_1542(this.method_37908(), maid.method_23317(), maid.method_23318() + 0.5, maid.method_23321(), result);
            itemEntity.method_18800(0.0, 0.1, 0.0);
            this.field_6002.method_8649((class_1297)itemEntity);
            this.field_6002.method_8649((class_1297)new class_1303(maid.method_37908(), maid.method_23317(), maid.method_23318() + 0.5, maid.method_23321(), this.field_5974.method_43048(6) + 1));
        }
    }

    protected void addExtraLoot(List<class_1799> randomItems) {
    }

    protected void afterFishing() {
        class_1309 class_13092;
        EntityMaid maidOwner = this.getMaidOwner();
        if (maidOwner != null && (class_13092 = maidOwner.method_35057()) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_13092;
            InitTrigger.MAID_EVENT.trigger(serverPlayer, "maid_fishing");
        }
    }

    protected void hurtRod(EntityMaid maid, class_1799 rodItem, int rodDamage) {
        rodItem.method_7956(rodDamage, (class_1309)maid, m -> maid.sendItemBreakMessage(rodItem));
    }

    private boolean calculateOpenWater(class_2338 pos) {
        OpenWaterType openWaterType = OpenWaterType.INVALID;
        for (int y = -1; y <= 2; ++y) {
            OpenWaterType openWaterTypeForArea = this.getOpenWaterTypeForArea(pos.method_10069(-2, y, -2), pos.method_10069(2, y, 2));
            switch (openWaterTypeForArea.ordinal()) {
                case 2: {
                    return false;
                }
                case 0: {
                    if (openWaterType != OpenWaterType.INVALID) break;
                    return false;
                }
                case 1: {
                    if (openWaterType != OpenWaterType.ABOVE_WATER) break;
                    return false;
                }
            }
            openWaterType = openWaterTypeForArea;
        }
        return true;
    }

    private OpenWaterType getOpenWaterTypeForArea(class_2338 firstPos, class_2338 secondPos) {
        return class_2338.method_20437((class_2338)firstPos, (class_2338)secondPos).map(this::getOpenWaterTypeForBlock).reduce((firstType, secondType) -> firstType == secondType ? firstType : OpenWaterType.INVALID).orElse(OpenWaterType.INVALID);
    }

    private OpenWaterType getOpenWaterTypeForBlock(class_2338 blockPos) {
        class_2680 blockState = this.field_6002.method_8320(blockPos);
        if (!blockState.method_26215() && !blockState.method_27852(class_2246.field_10588)) {
            class_3610 fluidState = blockState.method_26227();
            return fluidState.method_15767(class_3486.field_15517) && fluidState.method_15771() && blockState.method_26220((class_1922)this.method_37908(), blockPos).method_1110() ? OpenWaterType.INSIDE_WATER : OpenWaterType.INVALID;
        }
        return OpenWaterType.ABOVE_WATER;
    }

    public boolean isOpenWaterFishing() {
        return this.openWater;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public void method_5650(class_1297.class_5529 reason) {
        this.updateOwnerInfo(null);
        super.method_5650(reason);
    }

    public void method_36209() {
        this.updateOwnerInfo(null);
    }

    public void method_7432(@Nullable class_1297 owner) {
        super.method_7432(owner);
        this.updateOwnerInfo(this);
    }

    private void updateOwnerInfo(@Nullable MaidFishingHook fishingHook) {
        EntityMaid maid = this.getMaidOwner();
        if (maid != null) {
            maid.fishing = fishingHook;
        }
    }

    @Nullable
    public EntityMaid getMaidOwner() {
        class_1297 entity = this.method_24921();
        return entity instanceof EntityMaid ? (EntityMaid)entity : null;
    }

    private boolean shouldStopFishing(EntityMaid maid) {
        boolean hasVehicle;
        class_1799 mainHandItem = maid.method_6047();
        boolean hasFishingRod = mainHandItem.method_7909() instanceof class_1787;
        boolean isFishingTask = maid.getTask() instanceof TaskFishing;
        boolean bl = hasVehicle = maid.method_5854() != null;
        if (!maid.method_31481() && maid.method_5805() && hasVehicle && isFishingTask && hasFishingRod && this.method_5858((class_1297)maid) < 256.0) {
            return false;
        }
        this.method_31472();
        return true;
    }

    protected void method_5652(class_2487 compound) {
    }

    protected void method_5749(class_2487 compound) {
    }

    public boolean method_5822() {
        return false;
    }

    public class_2596<class_2602> method_18002() {
        class_1297 entity = this.method_24921();
        return new class_2604((class_1297)this, entity == null ? this.method_5628() : entity.method_5628());
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        if (this.getMaidOwner() == null) {
            int dataId = packet.method_11166();
            TouhouLittleMaid.LOGGER.error("Failed to recreate fishing hook on client. {} (id: {}) is not a valid owner.", (Object)this.field_6002.method_8469(dataId), (Object)dataId);
            this.method_5768();
        }
    }

    protected static enum FishHookState {
        FLYING,
        BOBBING;

    }

    protected static enum OpenWaterType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

