/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.CombinedInvWrapper;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCrossbowAttack;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1764;
import net.minecraft.class_1781;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_7893;
import org.jetbrains.annotations.Nullable;

public class TaskCrossBowAttack
implements IRangedAttackTask {
    public static final class_2960 UID = new class_2960("touhou_little_maid", "crossbow_attack");

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        return class_1802.field_8399.method_7854();
    }

    @Override
    @Nullable
    public class_3414 getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, InitSounds.MAID_RANGE_ATTACK, 0.5f);
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(entityMaid -> this.hasCrossBow((EntityMaid)entityMaid) && this.hasAmmunition((EntityMaid)entityMaid), IRangedAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.hasCrossBow(maid) || !this.hasAmmunition(maid) || this.farAway((class_1309)target, maid));
        class_7893<EntityMaid> moveToTargetTask = MaidRangedWalkToTarget.create(0.6f);
        MaidAttackStrafingTask maidAttackStrafingTask = new MaidAttackStrafingTask();
        MaidCrossbowAttack shootTargetTask = new MaidCrossbowAttack();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, moveToTargetTask), Pair.of((Object)5, (Object)((Object)maidAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(entityMaid -> this.hasCrossBow((EntityMaid)entityMaid) && this.hasAmmunition((EntityMaid)entityMaid), IRangedAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.hasCrossBow(maid) || !this.hasAmmunition(maid) || this.farAway((class_1309)target, maid));
        MaidCrossbowAttack shootTargetTask = new MaidCrossbowAttack();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)((Object)shootTargetTask))});
    }

    @Override
    public boolean canSee(EntityMaid maid, class_1309 target) {
        return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.CROSS_BOW_RANGE);
    }

    @Override
    public class_238 searchDimension(EntityMaid maid) {
        if (this.hasCrossBow(maid)) {
            float searchRange = this.searchRadius(maid);
            if (maid.method_18410()) {
                return new class_238(maid.method_18412()).method_1014((double)searchRange);
            }
            return maid.method_5829().method_1014((double)searchRange);
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        return ((Integer)MaidConfig.CROSS_BOW_RANGE.get()).intValue();
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, class_1309 target, float distanceFactor) {
        shooter.method_24654((class_1309)shooter, 1.6f);
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"has_crossbow", this::hasCrossBow), Pair.of((Object)"has_ammunition", this::hasAmmunition)});
    }

    @Override
    public boolean isWeapon(EntityMaid maid, class_1799 stack) {
        return stack.method_7909() instanceof class_1764;
    }

    private boolean hasCrossBow(EntityMaid maid) {
        return maid.method_6047().method_7909() instanceof class_1764;
    }

    private boolean hasAmmunition(EntityMaid maid) {
        return maid.method_6079().method_7909() instanceof class_1781 || this.hasArrow(maid);
    }

    private boolean hasArrow(EntityMaid maid) {
        return this.findArrow(maid) >= 0;
    }

    private int findArrow(EntityMaid maid) {
        class_1799 mainHandItem = maid.method_6047();
        if (mainHandItem.method_7909() instanceof class_1764) {
            CombinedInvWrapper handler = maid.getAvailableInv(true);
            return ItemsUtil.findStackSlot(handler, ((class_1764)mainHandItem.method_7909()).method_19268());
        }
        return -1;
    }

    private boolean farAway(class_1309 target, EntityMaid maid) {
        return maid.method_5739((class_1297)target) > this.searchRadius(maid);
    }
}

