/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.SlotItemHandler;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.ITriggerSlotChange;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidBaubleChangeEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.BaubleManager;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class BaubleContainer
extends MaidMainContainer {
    public static final class_3917<BaubleContainer> TYPE = new ExtendedScreenHandlerType((windowId, inv, data) -> new BaubleContainer(windowId, inv, data.readInt()));

    public BaubleContainer(int id, class_1661 inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
    }

    public static class_3908 create(final EntityMaid maid) {
        return new ExtendedScreenHandlerFactory(){

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                buf.writeInt(maid.method_5628());
            }

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Maid Bauble Container");
            }

            public class_1703 createMenu(int index, class_1661 inventory, class_1657 player) {
                int entityId = maid.method_5628();
                return new BaubleContainer(index, inventory, entityId);
            }

            public boolean shouldCloseCurrentScreen() {
                return false;
            }
        };
    }

    @Override
    protected void addMainDefaultInv() {
    }

    @Override
    protected void addBackpackInv(class_1661 inventory) {
        int level = this.maid.getFavorabilityManager().getLevel();
        int maxSize = this.maid.getMaidBauble().getSlots();
        for (int y = 0; !(y >= 6 || level <= 1 && y >= 2 || level == 2 && y >= 4); ++y) {
            for (int x = 0; x < 5; ++x) {
                int index = x + y * 5;
                if (index >= maxSize) {
                    return;
                }
                this.method_7621(new BaubleSlot(this.maid, index, 152 + 18 * x, 45 + 18 * y));
            }
        }
    }

    public static class BaubleSlot
    extends SlotItemHandler
    implements ITriggerSlotChange {
        private final EntityMaid maid;

        public BaubleSlot(EntityMaid maid, int index, int xPosition, int yPosition) {
            super(maid.getMaidBauble(), index, xPosition, yPosition);
            this.maid = maid;
        }

        @Override
        public void onShiftTakeoff(@Nullable class_1657 player, class_1799 stack) {
            IMaidBauble bauble;
            if (!this.maid.field_6002.field_9236 && !stack.method_7960() && (bauble = BaubleManager.getBauble(stack)) != null) {
                bauble.onTakeOff(this.maid, stack);
                ((MaidBaubleChangeEvent.TakeOffCallback)MaidBaubleChangeEvent.TAKE_OFF.invoker()).takeOff(new MaidBaubleChangeEvent.TakeOff(this.maid, stack));
            }
        }

        public void method_7667(class_1657 player, class_1799 stack) {
            super.method_7667(player, stack);
            this.onShiftTakeoff(player, stack);
        }

        public void method_48931(class_1799 stack) {
            IMaidBauble bauble;
            super.method_48931(stack);
            if (!this.maid.field_6002.field_9236 && !stack.method_7960() && (bauble = BaubleManager.getBauble(stack)) != null) {
                bauble.onPutOn(this.maid, stack);
                ((MaidBaubleChangeEvent.PutOnCallback)MaidBaubleChangeEvent.PUT_ON.invoker()).putOn(new MaidBaubleChangeEvent.PutOn(this.maid, stack));
            }
        }
    }
}

