/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.BoardStateTooltip;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5632;
import org.apache.commons.lang3.StringUtils;

public class ItemBoardState
extends class_1792 {
    public static final String DATA_TAG = "BoardStateData";
    public static final String DESC_TAG = "BoardStateDesc";
    public static final String AUTHOR_TAG = "BoardStateAuthor";

    public ItemBoardState() {
        super(new class_1792.class_1793());
    }

    public static void setState(class_1799 stack, String data, String desc, String author) {
        class_2487 tag = stack.method_7948();
        tag.method_10582(DATA_TAG, data);
        tag.method_10582(DESC_TAG, desc);
        tag.method_10582(AUTHOR_TAG, author);
    }

    @Nullable
    public static String[] getState(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return null;
        }
        if (!tag.method_10573(DATA_TAG, 8)) {
            return null;
        }
        return new String[]{tag.method_10558(DATA_TAG), tag.method_10558(DESC_TAG), tag.method_10558(AUTHOR_TAG)};
    }

    @Environment(value=EnvType.CLIENT)
    public Optional<class_5632> method_32346(class_1799 stack) {
        if (!class_437.method_25442()) {
            return Optional.empty();
        }
        String[] state = ItemBoardState.getState(stack);
        if (state == null) {
            return Optional.empty();
        }
        String stateData = state[0];
        if (StringUtils.isBlank((CharSequence)stateData)) {
            return Optional.empty();
        }
        if (stack.method_31574(InitItems.GOMOKU_BOARD_STATE)) {
            return Optional.of(BoardStateTooltip.ofGomoku(stateData));
        }
        if (stack.method_31574(InitItems.CCHESS_BOARD_STATE)) {
            return Optional.of(BoardStateTooltip.ofXiangqi(stateData));
        }
        if (stack.method_31574(InitItems.WCHESS_BOARD_STATE)) {
            return Optional.of(BoardStateTooltip.ofChess(stateData));
        }
        return Optional.empty();
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        String author;
        String[] state = ItemBoardState.getState(stack);
        if (state == null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltips.touhou_little_maid.board_state.empty").method_27692(class_124.field_1080));
            return;
        }
        String descKey = state[1];
        if (StringUtils.isNotBlank((CharSequence)descKey)) {
            tooltip.add((class_2561)class_2561.method_43471((String)descKey).method_27692(class_124.field_1080));
        }
        if (StringUtils.isNotBlank((CharSequence)(author = state[2]))) {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltips.touhou_little_maid.board_state.author", (Object[])new Object[]{author}).method_27692(class_124.field_1080));
        }
        if (!class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"board_state.touhou_little_maid.show_picture").method_27692(class_124.field_1063).method_27692(class_124.field_1056));
        }
    }
}

