/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import cn.sh1rocu.touhoulittlemaid.api.extension.IItemRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity.TileEntityItemStackGarageKitRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.YsmMaidInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_756;
import net.minecraft.class_7923;

public class ItemGarageKit
extends class_1747
implements IItemRenderer {
    private static final String ENTITY_INFO = "EntityInfo";
    private static final String DEFAULT_ENTITY_ID = "touhou_little_maid:maid";
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    private static final String ENTITY_ID_TAG_NAME = "id";
    private static final class_2487 DEFAULT_DATA = ItemGarageKit.getDefaultData();

    public ItemGarageKit() {
        super(InitBlocks.GARAGE_KIT, new class_1792.class_1793().method_7889(1));
    }

    private static boolean hasMaidData(class_1799 stack) {
        return stack.method_7985() && !Objects.requireNonNull(stack.method_7969()).method_10562(ENTITY_INFO).method_33133();
    }

    public static class_2487 getMaidData(class_1799 stack) {
        if (ItemGarageKit.hasMaidData(stack)) {
            return Objects.requireNonNull(stack.method_7969()).method_10562(ENTITY_INFO);
        }
        return DEFAULT_DATA;
    }

    private static class_2487 getDefaultData() {
        class_2487 data = new class_2487();
        data.method_10582(ENTITY_ID_TAG_NAME, DEFAULT_ENTITY_ID);
        data.method_10582("ModelId", DEFAULT_MODEL_ID);
        data.method_10556("IsYsmModel", false);
        return data;
    }

    @Environment(value=EnvType.CLIENT)
    public class_2561 method_7864(class_1799 stack) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            YsmMaidInfo ysmMaidInfo;
            class_5250 prefix = class_2561.method_43471((String)"block.touhou_little_maid.garage_kit.prefix");
            class_2487 data = ItemGarageKit.getMaidData(stack);
            String entityId = data.method_10558(ENTITY_ID_TAG_NAME);
            if (!entityId.equals(DEFAULT_ENTITY_ID)) {
                class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(new class_2960(entityId));
                return prefix.method_10852(entityType.method_5897());
            }
            if (YsmCompat.isInstalled() && (ysmMaidInfo = YsmCompat.getYsmMaidInfo(data)).isYsmModel()) {
                class_5250 name = ysmMaidInfo.name();
                if (name == null || name.equals((Object)class_2561.method_43473())) {
                    return prefix.method_27693(ysmMaidInfo.modelId());
                }
                return prefix.method_10852((class_2561)name);
            }
            String modelId = data.method_10558("ModelId");
            MaidModelInfo info = CustomPackLoader.MAID_MODELS.getInfo(modelId).orElse(null);
            if (info != null) {
                return prefix.method_10852((class_2561)ParseI18n.parse(info.getName()));
            }
            return super.method_7864(stack);
        }
        return super.method_7864(stack);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_756 getCustomRenderer() {
        return TileEntityItemStackGarageKitRenderer.INSTANCE.get();
    }
}

