/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAndItemTransformEvent;
import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.AbstractStoreMaidItem;
import com.github.tartaricacid.touhoulittlemaid.util.PlaceHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_5632;

public class ItemSmartSlab
extends AbstractStoreMaidItem {
    private static final String MAID_OWNER = "Owner";
    private final Type type;

    public ItemSmartSlab(Type type) {
        super(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8903));
        this.type = type;
    }

    public static void storeMaidData(class_1799 stack, EntityMaid maid) {
        class_2487 data = stack.method_7911("MaidInfo");
        maid.method_5647(data);
        MaidAndItemTransformEvent.ToItem event = new MaidAndItemTransformEvent.ToItem(maid, stack, data);
        ((MaidAndItemTransformEvent.ToItemCallback)MaidAndItemTransformEvent.TO_ITEM.invoker()).onToItem(event);
    }

    public String method_7876() {
        return "item.touhou_little_maid.smart_slab";
    }

    public class_1269 method_7884(class_1838 context) {
        class_2350 clickedFace = context.method_8038();
        class_1657 player = context.method_8036();
        class_1937 worldIn = context.method_8045();
        class_2338 clickedPos = context.method_8037();
        if (player == null) {
            return super.method_7884(context);
        }
        if (clickedFace == class_2350.field_11036 && !PlaceHelper.notSuitableForPlaceMaid(worldIn, clickedPos)) {
            EntityMaid maid = (EntityMaid)InitEntities.MAID.method_5883(worldIn);
            if (maid == null) {
                return super.method_7884(context);
            }
            if (this.type == Type.INIT) {
                return this.spawnNewMaid(context, player, worldIn, maid);
            }
            if (this.type == Type.HAS_MAID) {
                return this.spawnFromStore(context, player, worldIn, maid);
            }
        } else if (worldIn.field_9236) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.photo.not_suitable_for_place_maid"));
        }
        return super.method_7884(context);
    }

    private class_1269 spawnFromStore(class_1838 context, class_1657 player, class_1937 worldIn, EntityMaid maid) {
        class_1799 stack = context.method_8041();
        if (ItemSmartSlab.hasMaidData(stack)) {
            class_2487 maidData = ItemSmartSlab.getMaidData(stack);
            UUID ownerUid = maidData.method_25926(MAID_OWNER);
            if (!player.method_5667().equals(ownerUid)) {
                return class_1269.field_5814;
            }
            MaidAndItemTransformEvent.ToMaid event = new MaidAndItemTransformEvent.ToMaid(maid, stack, maidData);
            ((MaidAndItemTransformEvent.ToMaidCallback)MaidAndItemTransformEvent.TO_MAID.invoker()).onToMaid(event);
            maid.method_5651(maidData);
            maid.method_5725(context.method_8037().method_10084(), 0.0f, 0.0f);
            if (worldIn instanceof class_3218) {
                worldIn.method_8649((class_1297)maid);
            }
            maid.spawnExplosionParticle();
            maid.method_5783(class_3417.field_14810, 1.0f, worldIn.field_9229.method_43057() * 0.1f + 0.9f);
            player.method_6122(context.method_20287(), InitItems.SMART_SLAB_EMPTY.method_7854());
            player.method_7357().method_7906(InitItems.SMART_SLAB_EMPTY, 20);
            return class_1269.method_29236((boolean)worldIn.field_9236);
        }
        return super.method_7884(context);
    }

    private class_1269 spawnNewMaid(class_1838 context, class_1657 player, class_1937 worldIn, EntityMaid maid) {
        MaidNumAttachment cap = (MaidNumAttachment)player.getAttachedOrCreate(InitDataAttachment.MAID_NUM, () -> new MaidNumAttachment(0));
        if (cap.canAdd() || player.method_7337()) {
            if (!player.method_7337()) {
                cap.add();
            }
            maid.method_6170(player);
            if (worldIn instanceof class_3218) {
                maid.method_5943((class_5425)((class_3218)worldIn), worldIn.method_8404(context.method_8037()), class_3730.field_16465, null, null);
                maid.method_5725(context.method_8037().method_10084(), 0.0f, 0.0f);
                worldIn.method_8649((class_1297)maid);
            }
            maid.spawnExplosionParticle();
            maid.method_5783(class_3417.field_14810, 1.0f, worldIn.field_9229.method_43057() * 0.1f + 0.9f);
            player.method_6122(context.method_20287(), InitItems.SMART_SLAB_EMPTY.method_7854());
            player.method_7357().method_7906(InitItems.SMART_SLAB_EMPTY, 20);
            return class_1269.method_29236((boolean)worldIn.field_9236);
        }
        if (worldIn.field_9236) {
            player.method_43496((class_2561)class_2561.method_43469((String)"message.touhou_little_maid.owner_maid_num.can_not_add", (Object[])new Object[]{cap.get(), cap.getMaxNum()}));
        }
        return super.method_7884(context);
    }

    public boolean method_7886(class_1799 stack) {
        return this.type != Type.EMPTY;
    }

    public boolean method_31568() {
        return this.type != Type.HAS_MAID;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (this.type == Type.INIT) {
            class_5250 text = class_2561.method_43469((String)"tooltips.touhou_little_maid.smart_slab.maid_name", (Object[])new Object[]{class_1074.method_4662((String)"tooltips.touhou_little_maid.smart_slab.maid_name.unknown", (Object[])new Object[0])});
            tooltip.add((class_2561)text.method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltips.touhou_little_maid.smart_slab.desc").method_27692(class_124.field_1080));
    }

    @Override
    public Optional<class_5632> method_32346(class_1799 stack) {
        if (this.type == Type.HAS_MAID) {
            return super.method_32346(stack);
        }
        return Optional.empty();
    }

    public static enum Type {
        INIT,
        EMPTY,
        HAS_MAID;

    }
}

