/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameEntityBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.GomokuCodec;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class TileEntityGomoku
extends TileEntityJoy
implements IBoardGameEntityBlock {
    public static final class_2591<TileEntityGomoku> TYPE = class_2591.class_2592.method_20528(TileEntityGomoku::new, (class_2248[])new class_2248[]{InitBlocks.GOMOKU}).method_11034(null);
    private static final String CHESS_DATA = "ChessData";
    private static final String STATUE = "Statue";
    private static final String PLAYER_TURN = "PlayerTurn";
    private static final String CHESS_COUNTER = "ChessCounter";
    private static final String LATEST_CHESS_POINT = "LatestChessPoint";
    private int[][] chessData = new int[15][15];
    private int statue = Statue.IN_PROGRESS.ordinal();
    private boolean playerTurn = true;
    private int chessCounter = 0;
    private Point latestChessPoint = Point.NULL;

    public TileEntityGomoku(class_2338 pos, class_2680 blockState) {
        super(TYPE, pos, blockState);
    }

    @Override
    protected void method_11007(class_2487 tag) {
        class_2499 listTag = new class_2499();
        for (int[] chessRow : this.chessData) {
            listTag.add((Object)new class_2495(chessRow));
        }
        this.tlm$getPersistentData().method_10566(CHESS_DATA, (class_2520)listTag);
        this.tlm$getPersistentData().method_10569(STATUE, this.statue);
        this.tlm$getPersistentData().method_10556(PLAYER_TURN, this.playerTurn);
        this.tlm$getPersistentData().method_10569(CHESS_COUNTER, this.chessCounter);
        this.tlm$getPersistentData().method_10566(LATEST_CHESS_POINT, (class_2520)Point.toTag(this.latestChessPoint));
        super.method_11007(tag);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_2499 listTag = this.tlm$getPersistentData().method_10554(CHESS_DATA, 11);
        for (int i = 0; i < listTag.size(); ++i) {
            int[] intArray = listTag.method_36111(i);
            this.chessData[i] = intArray;
        }
        this.statue = this.tlm$getPersistentData().method_10550(STATUE);
        this.playerTurn = this.tlm$getPersistentData().method_10577(PLAYER_TURN);
        this.chessCounter = this.tlm$getPersistentData().method_10550(CHESS_COUNTER);
        this.latestChessPoint = Point.fromTag(this.tlm$getPersistentData().method_10562(LATEST_CHESS_POINT));
    }

    public void reset() {
        this.chessData = new int[15][15];
        this.statue = Statue.IN_PROGRESS.ordinal();
        this.playerTurn = true;
        this.chessCounter = 0;
        this.latestChessPoint = Point.NULL;
    }

    public int[][] getChessData() {
        return this.chessData;
    }

    public void setChessData(int x, int y, int type) {
        this.chessData[x][y] = type;
        this.latestChessPoint = new Point(x, y, type);
        ++this.chessCounter;
    }

    public void clickWithDebug() {
        int[][] drawBoard = new int[15][15];
        for (int x = 0; x < 15; ++x) {
            boolean blackFirst = x / 2 % 2 == 0;
            for (int y = 0; y < 15; ++y) {
                drawBoard[x][y] = x == 14 && 12 <= y ? 0 : (blackFirst ? (y % 2 == 0 ? 1 : 2) : (y % 2 == 0 ? 2 : 1));
            }
        }
        this.chessData = drawBoard;
        this.latestChessPoint = new Point(14, 10, 2);
        this.chessCounter = 222;
        this.statue = Statue.IN_PROGRESS.ordinal();
        this.playerTurn = true;
    }

    public boolean isPlayerTurn() {
        return this.playerTurn;
    }

    public void setPlayerTurn(boolean playerTurn) {
        this.playerTurn = playerTurn;
    }

    public void setStatue(Statue statue) {
        this.statue = statue.ordinal();
    }

    public Statue getStatue() {
        return Statue.values()[class_3532.method_15340((int)this.statue, (int)0, (int)(Statue.values().length - 1))];
    }

    public int getChessCounter() {
        return this.chessCounter;
    }

    public Point getLatestChessPoint() {
        return this.latestChessPoint;
    }

    public GomokuCodec.StateData getStateData() {
        return new GomokuCodec.StateData(this.chessData, this.chessCounter, this.latestChessPoint);
    }

    public void setStateData(GomokuCodec.StateData stateData) {
        this.chessData = stateData.board();
        this.chessCounter = stateData.turnCount();
        this.latestChessPoint = stateData.latestPoint();
        this.refresh();
    }
}

