/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class MaidFluidRender {
    private static final int TEXTURE_SIZE = 16;

    public static class_2561 getFluidName(String fluidId, long amount) {
        class_2960 location = class_2960.method_12829((String)fluidId);
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(location);
        if (location == null || amount <= 0L || fluid.method_15780(class_3612.field_15906)) {
            return class_2561.method_43471((String)"tooltips.touhou_little_maid.tank_backpack.empty_fluid");
        }
        return FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((class_3611)fluid));
    }

    public static void drawFluid(class_332 graphics, int x, int y, int width, int height, String fluidId, int amount, int capacity) {
        class_2960 location = class_2960.method_12829((String)fluidId);
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(location);
        if (location == null || amount <= 0 || fluid.method_15780(class_3612.field_15906)) {
            return;
        }
        FluidVariant fluidStack = FluidVariant.of((class_3611)fluid);
        MaidFluidRender.getStillFluidSprite(fluidStack).ifPresent(fluidStillSprite -> {
            int fluidColor = MaidFluidRender.getColorTint(fluidStack);
            int scaledAmount = amount * height / capacity;
            if (scaledAmount < 1) {
                scaledAmount = 1;
            }
            if (scaledAmount > height) {
                scaledAmount = height;
            }
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)x, (float)y, 0.0f);
            MaidFluidRender.drawTiledSprite(graphics, width, height, fluidColor, scaledAmount, fluidStillSprite);
            graphics.method_51448().method_22909();
        });
    }

    public static int getColorTint(FluidVariant ingredient) {
        return FluidVariantRendering.getColor((FluidVariant)ingredient);
    }

    public static Optional<class_1058> getStillFluidSprite(FluidVariant fluidStack) {
        class_1058 fluidStill = FluidVariantRendering.getSprite((FluidVariant)fluidStack);
        return Optional.ofNullable(fluidStill);
    }

    private static void drawTiledSprite(class_332 guiGraphics, int tiledWidth, int tiledHeight, int color, long scaledAmount, class_1058 sprite) {
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        Matrix4f matrix = guiGraphics.method_51448().method_23760().method_23761();
        MaidFluidRender.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        long yTileCount = scaledAmount / 16L;
        long yRemainder = scaledAmount - yTileCount * 16L;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int yTile = 0;
            while ((long)yTile <= yTileCount) {
                int width = xTile == xTileCount ? xRemainder : 16;
                long height = (long)yTile == yTileCount ? yRemainder : 16L;
                int x = xTile * 16;
                int y = tiledHeight - (yTile + 1) * 16;
                if (width > 0 && height > 0L) {
                    long maskTop = 16L - height;
                    int maskRight = 16 - width;
                    MaidFluidRender.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
                }
                ++yTile;
            }
        }
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, class_1058 textureSprite, long maskTop, long maskRight, float zLevel) {
        float uMin = textureSprite.method_4594();
        float uMax = textureSprite.method_4577();
        float vMin = textureSprite.method_4593();
        float vMax = textureSprite.method_4575();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        RenderSystem.setShader(class_757::method_34542);
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, xCoord, yCoord + 16.0f, zLevel).method_22913(uMin, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).method_22913(uMax, vMax).method_1344();
        bufferBuilder.method_22918(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).method_22913(uMax, vMin).method_1344();
        bufferBuilder.method_22918(matrix, xCoord, yCoord + (float)maskTop, zLevel).method_22913(uMin, vMin).method_1344();
        tesselator.method_1350();
    }
}

