package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.isValidResourceLocation;

public class ConditionalPassenger {
    private static final String EMPTY = "";
    private final List<class_2960> idTest = Lists.newArrayList();
    private final List<class_6862<class_1299<?>>> tagTest = Lists.newArrayList();
    private final String idPre;
    private final String tagPre;

    public ConditionalPassenger() {
        this.idPre = "passenger$";
        this.tagPre = "passenger#";
    }

    public void addTest(String name) {
        int preSize = this.idPre.length();
        if (name.length() <= preSize) {
            return;
        }
        String substring = name.substring(preSize);
        if (name.startsWith(idPre) && isValidResourceLocation(substring)) {
            idTest.add(class_2960.method_60654(substring));
        }
        if (name.startsWith(tagPre) && isValidResourceLocation(substring)) {
            tagTest.add(class_6862.method_40092(
                    class_7924.field_41266,
                    class_2960.method_60654(substring)
            ));
        }
    }

    public String doTest(class_1308 maid) {
        class_1297 passenger = maid.method_31483();
        if (passenger == null || !passenger.method_5805()) {
            return EMPTY;
        }
        String result = doIdTest(passenger);
        if (result.isEmpty()) {
            return doTagTest(passenger);
        }
        return result;
    }

    private String doIdTest(class_1297 passenger) {
        if (idTest.isEmpty()) {
            return EMPTY;
        }
        class_2960 registryName = class_7923.field_41177.method_10221(passenger.method_5864());
        if (idTest.contains(registryName)) {
            return idPre + registryName;
        }
        return EMPTY;
    }

    private String doTagTest(class_1297 passenger) {
        if (tagTest.isEmpty()) {
            return EMPTY;
        }
        return tagTest.stream().filter(tag -> passenger.method_5864().method_20210(tag)).findFirst().map(itemTagKey -> tagPre + itemTagKey.comp_327()).orElse(EMPTY);
    }
}
