package com.github.tartaricacid.touhoulittlemaid.client.overlay;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.compat.kubejs.ModKubeJSCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import net.minecraft.class_9080;
import net.minecraft.class_9779;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Map;

import static com.github.tartaricacid.touhoulittlemaid.config.subconfig.RenderConfig.*;

public class MaidTipsOverlay implements class_9080.class_9081 {
    private static final class_2960 ICON = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/maid_tips_icon.png");

    private static Map<class_1792, class_5250> TIPS = Maps.newHashMap();
    private static Map<class_1792, ModConfigSpec.BooleanValue> TIPS_CONFIG = Maps.newHashMap();
    private static Map<CheckCondition, class_5250> SPECIAL_TIPS = Maps.newHashMap();

    public static MaidTipsOverlay INSTANCE;

    public MaidTipsOverlay() {
        TIPS = Maps.newHashMap();
        TIPS_CONFIG = Maps.newHashMap();
        SPECIAL_TIPS = Maps.newHashMap();
    }

    public static void init() {
        INSTANCE = new MaidTipsOverlay();

        INSTANCE.addTips("overlay.touhou_little_maid.compass.tips", ENABLE_COMPASS_TIP, class_1802.field_8251);
        INSTANCE.addTips("overlay.touhou_little_maid.golden_apple.tips", ENABLE_GOLDEN_APPLE_TIP, class_1802.field_8463, class_1802.field_8367);
        INSTANCE.addTips("overlay.touhou_little_maid.potion.tips", ENABLE_POTION_TIP, class_1802.field_8574);
        INSTANCE.addTips("overlay.touhou_little_maid.milk_bucket.tips", ENABLE_MILK_BUCKET_TIP, class_1802.field_8103);
        INSTANCE.addTips("overlay.touhou_little_maid.glass_bottle.tips", ENABLE_GLASS_BOTTLE_TIP, class_1802.field_8469);
        INSTANCE.addTips("overlay.touhou_little_maid.name_tag.tips", ENABLE_NAME_TAG_TIP, class_1802.field_8448);
        INSTANCE.addTips("overlay.touhou_little_maid.lead.tips", ENABLE_LEAD_TIP, class_1802.field_8719);
        INSTANCE.addTips("overlay.touhou_little_maid.debug_stick.tips", class_1802.field_8688);
        INSTANCE.addTips("overlay.touhou_little_maid.saddle.tips", ENABLE_SADDLE_TIP, class_1802.field_8175);

        INSTANCE.addSpecialTips("overlay.touhou_little_maid.ntr_item.tips", (item, maid, player) -> !maid.method_6171(player) && EntityMaid.getNtrItem().method_8093(item));
        INSTANCE.addSpecialTips("overlay.touhou_little_maid.remove_backpack.tips", MaidTipsOverlay::checkShears);

        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.addMaidTips(INSTANCE);
        }
        ModKubeJSCompat.maidTipsOverlayInit(INSTANCE);

        TIPS = ImmutableMap.copyOf(TIPS);
        TIPS_CONFIG = ImmutableMap.copyOf(TIPS_CONFIG);
        SPECIAL_TIPS = ImmutableMap.copyOf(SPECIAL_TIPS);
    }

    private static boolean checkShears(class_1799 item, EntityMaid maid, class_746 player) {
        if (!ENABLE_SHEARS_TIP.get()) {
            return false;
        }
        return maid.method_6171(player) && maid.hasBackpack() && item.method_31573(ConventionalItemTags.SHEAR_TOOLS);
    }

    private static class_5250 checkSpecialTips(class_1799 mainhandItem, EntityMaid maid, class_746 player) {
        for (Map.Entry<CheckCondition, class_5250> entry : SPECIAL_TIPS.entrySet()) {
            CheckCondition condition = entry.getKey();
            class_5250 text = entry.getValue();
            if (condition.test(mainhandItem, maid, player)) {
                return text;
            }
        }
        return null;
    }

    @Override
    public void render(@NotNull class_332 guiGraphics, @NotNull class_9779 deltaTracker) {
        class_310 minecraft = class_310.method_1551();
        class_315 options = minecraft.field_1690;

        if (!options.method_31044().method_31034()) {
            return;
        }
        if (minecraft.field_1761 == null || minecraft.field_1761.method_2920() == class_1934.field_9219) {
            return;
        }
        if (!(minecraft.field_1765 instanceof class_3966 result)) {
            return;
        }
        if (!(result.method_17782() instanceof EntityMaid maid)) {
            return;
        }
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return;
        }
        if (!maid.method_5805()) {
            return;
        }
        // 如果女仆和玩家同骑乘一个实体，很容易出现提示闪烁问题，故禁用
        if (player.method_5854() != null && player.method_5854().equals(maid.method_5854())) {
            return;
        }

        class_5250 tip;
        class_1799 itemStack = player.method_6047();
        class_1792 item = itemStack.method_7909();
        if (maid.method_6171(player) && TIPS.containsKey(item)) {
            boolean configIsNull = !TIPS_CONFIG.containsKey(item);
            boolean configIsEnable = TIPS_CONFIG.containsKey(item) && TIPS_CONFIG.get(item).get();
            if (configIsNull || configIsEnable) {
                tip = TIPS.get(item);
            } else {
                tip = checkSpecialTips(itemStack, maid, player);
            }
        } else {
            tip = checkSpecialTips(itemStack, maid, player);
        }
        if (tip != null) {
            int screenHeight = guiGraphics.method_51443();
            int screenWidth = guiGraphics.method_51421();
            List<class_5481> split = minecraft.field_1772.method_1728(tip, 120);
            int offset = (screenHeight / 2 - 5) - split.size() * 10;
            guiGraphics.method_51427(itemStack, screenWidth / 2 + 32, offset);
            guiGraphics.method_25290(ICON, screenWidth / 2 + 42, offset - 4, 16, 16, 16, 16, 16, 16);
            offset += 18;
            for (class_5481 sequence : split) {
                guiGraphics.method_35720(minecraft.field_1772, sequence, screenWidth / 2 + 32, offset, 0xFFFFFF);
                offset += 10;
            }
        }
    }

    public void addTips(String key, class_1792... items) {
        addTips(key, null, items);
    }

    public void addTips(String key, @Nullable ModConfigSpec.BooleanValue config, class_1792... items) {
        for (class_1792 item : items) {
            TIPS.put(item, class_2561.method_43471(key));
            if (config != null) {
                TIPS_CONFIG.put(item, config);
            }
        }
    }

    public void addSpecialTips(String key, CheckCondition condition) {
        SPECIAL_TIPS.put(condition, class_2561.method_43471(key));
    }

    public interface CheckCondition {
        boolean test(class_1799 mainhandItem, EntityMaid maid, class_746 player);
    }
}