package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.implement;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.EntityGraphics;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_7833;

public class WaitingChatBubbleRenderer implements IChatBubbleRenderer {
    private final class_327 font;
    private final int width;
    private final class_2960 bg;
    private final class_2561 text;
    private final class_2960 icon;

    public WaitingChatBubbleRenderer(class_2960 bg, class_2561 text, class_2960 icon) {
        this.font = class_310.method_1551().field_1772;
        this.width = font.method_27525(text);
        this.bg = bg;
        this.text = text;
        this.icon = icon;
    }

    @Override
    public int getHeight() {
        return 16;
    }

    @Override
    public int getWidth() {
        return this.width + 18;
    }

    @Override
    public void render(EntityMaidRenderer renderer, EntityGraphics graphics) {
        graphics.getPoseStack().method_22903();
        float time = (class_156.method_658() % 3600);
        graphics.getPoseStack().method_46416(8, 8, 0);
        graphics.getPoseStack().method_22907(class_7833.field_40718.rotationDegrees(time));
        graphics.blit(this.icon, -8, -8, 0, 0, 16, 16, 16, 16);
        graphics.getPoseStack().method_22909();
        graphics.drawString(font, this.text, 18, (16 - font.field_2000) / 2 + 1, 0x000000, false);
    }

    @Override
    public class_2960 getBackgroundTexture() {
        return this.bg;
    }
}