package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.client.event.ReloadResourceEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.info.ServerCustomPackLoader;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public final class PackCommand {
    private static final String PACK_NAME = "pack";
    private static final String RELOAD_NAME = "reload";

    public static LiteralArgumentBuilder<class_2168> get() {
        LiteralArgumentBuilder<class_2168> pack = class_2170.method_9247(PACK_NAME);
        LiteralArgumentBuilder<class_2168> reload = class_2170.method_9247(RELOAD_NAME);
        pack.then(reload.executes(PackCommand::reloadAllPack));
        return pack;
    }

    private static int reloadAllPack(CommandContext<class_2168> context) {
        context.getSource().method_9226(() -> class_2561.method_43471("commands.touhou_little_maid.pack.reload.start"), true);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ReloadResourceEvent.asyncReloadAllPack();
        }
        ServerCustomPackLoader.reloadPacks();
        return Command.SINGLE_SUCCESS;
    }
}