package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record StorageAndTakePowerPackage(class_2338 pos, float powerNum,
                                         boolean isStorage) implements class_8710 {
    public static final class_8710.class_9154<StorageAndTakePowerPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("save_and_take_power"));
    public static final class_9139<ByteBuf, StorageAndTakePowerPackage> STREAM_CODEC = class_9139.method_56436(
            class_2338.field_48404,
            StorageAndTakePowerPackage::pos,
            class_9135.field_48552,
            StorageAndTakePowerPackage::powerNum,
            class_9135.field_48547,
            StorageAndTakePowerPackage::isStorage,
            StorageAndTakePowerPackage::new
    );

    public static void handle(StorageAndTakePowerPackage message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 sender = context.player();
            class_1937 world = sender.method_37908();
            if (world.method_8477(message.pos)) {
                class_2586 te = world.method_8321(message.pos);
                if (te instanceof TileEntityMaidBeacon beacon) {
                    PowerAttachment power = sender.getAttachedOrCreate(InitDataAttachment.POWER_NUM);
                    MaidNumAttachment maidNum = sender.getAttachedOrCreate(InitDataAttachment.MAID_NUM);
                    if (message.isStorage) {
                        storageLogic(message.powerNum, power, beacon);
                    } else {
                        takeLogic(message.powerNum, power, beacon);
                    }

                    ServerPlayNetworking.send(sender, new SyncDataPackage(power.get(), maidNum.get()));
                }
            }
        });
    }

    private static void storageLogic(float powerNum, PowerAttachment playerPower, TileEntityMaidBeacon beacon) {
        boolean playerPowerIsEnough = powerNum <= playerPower.get();
        boolean beaconNotFull = powerNum + beacon.getStoragePower() <= beacon.getMaxStorage();
        if (playerPowerIsEnough) {
            if (beaconNotFull) {
                playerPower.min(powerNum);
                beacon.setStoragePower(beacon.getStoragePower() + powerNum);
            } else {
                playerPower.min(beacon.getMaxStorage() - beacon.getStoragePower());
                beacon.setStoragePower(beacon.getMaxStorage());
            }
        }
    }

    private static void takeLogic(float powerNum, PowerAttachment playerPower, TileEntityMaidBeacon beacon) {
        boolean beaconIsEnough = powerNum <= beacon.getStoragePower();
        boolean playerNotFull = powerNum + playerPower.get() < PowerAttachment.MAX_POWER;
        if (beaconIsEnough) {
            if (playerNotFull) {
                beacon.setStoragePower(beacon.getStoragePower() - powerNum);
                playerPower.add(powerNum);
            } else {
                beacon.setStoragePower(beacon.getStoragePower() - PowerAttachment.MAX_POWER + playerPower.get());
                playerPower.set(PowerAttachment.MAX_POWER);
            }
        }
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
