package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.event.MaidAreaRenderEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record SyncMaidAreaPackage(int id, SchedulePos schedulePos) implements class_8710 {
    public static final class_8710.class_9154<SyncMaidAreaPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("sync_maid_area"));
    public static final class_9139<class_9129, SyncMaidAreaPackage> STREAM_CODEC = class_9139.method_56435(
            class_9135.field_48550,
            SyncMaidAreaPackage::id,
            SchedulePos.SCHEDULE_POS_STREAM_CODEC,
            SyncMaidAreaPackage::schedulePos,
            SyncMaidAreaPackage::new
    );

    public static void handle(SyncMaidAreaPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> writePos(message));
    }

    @Environment(EnvType.CLIENT)
    private static void writePos(SyncMaidAreaPackage message) {
        MaidAreaRenderEvent.addSchedulePos(message.id, message.schedulePos);
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
