package cn.sh1rocu.touhoulittlemaid.mixin.client;

import cn.sh1rocu.touhoulittlemaid.api.event.EntityJoinLevelEvent;
import cn.sh1rocu.touhoulittlemaid.api.extension.IEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_3695;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Supplier;

@Environment(EnvType.CLIENT)
@Mixin(class_638.class)
public abstract class ClientLevelMixin extends class_1937 {
    protected ClientLevelMixin(class_5269 levelData, class_5321<class_1937> dimension, class_5455 registryAccess, class_6880<class_2874> dimensionTypeRegistration, Supplier<class_3695> profiler, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxChainedNeighborUpdates) {
        super(levelData, dimension, registryAccess, dimensionTypeRegistration, profiler, isClientSide, isDebug, biomeZoomSeed, maxChainedNeighborUpdates);
    }

    @Inject(method = "addEntity", at = @At("HEAD"), cancellable = true)
    public void tlm$entityJoinLevelEvent(class_1297 entity, CallbackInfo ci) {
        EntityJoinLevelEvent event = new EntityJoinLevelEvent(entity, this);
        EntityJoinLevelEvent.CALLBACK.invoker().post(event);
        if (event.isCanceled())
            ci.cancel();
    }

    @Inject(method = "addEntity", at = @At("TAIL"))
    public void tlm$addedToWorld(class_1297 entity, CallbackInfo ci) {
        if (entity instanceof IEntity iEntity)
            iEntity.onAddedToLevel();
    }

    @Mixin(targets = "net/minecraft/client/multiplayer/ClientLevel$EntityCallbacks")
    public abstract static class EntityCallbacksMixin {
        @Inject(method = "onTrackingEnd(Lnet/minecraft/world/entity/Entity;)V", at = @At("TAIL"))
        private void tlm$removedFromLevel(class_1297 entity, CallbackInfo ci) {
            if (entity instanceof IEntity iEntity)
                iEntity.onRemovedFromLevel();
        }
    }
}