package cn.sh1rocu.touhoulittlemaid.mixin.common;

import cn.sh1rocu.touhoulittlemaid.api.extension.ILootTable;
import cn.sh1rocu.touhoulittlemaid.api.extension.ILootTableBuilder;
import cn.sh1rocu.touhoulittlemaid.api.mixin.LootCollector;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_52;

// Porting_Lib
@Mixin(value = class_52.class, priority = 50_000)
// high priority to make sure the WrapMethod below catches most injections
public class LootTableMixin implements ILootTable {
    @Unique
    private class_2960 tlm$lootTableId;

    @Override
    public void tlm$setLootTableId(final class_2960 id) {
        if (this.tlm$lootTableId != null)
            throw new IllegalStateException("Attempted to rename loot table from '" + this.tlm$lootTableId + "' to '" + id + "': this is not supported");
        this.tlm$lootTableId = Objects.requireNonNull(id);
    }

    @Override
    public class_2960 tlm$getLootTableId() {
        return this.tlm$lootTableId;
    }

    @WrapMethod(method = "getRandomItemsRaw(Lnet/minecraft/world/level/storage/loot/LootContext;Ljava/util/function/Consumer;)V")
    private void finishCollectingLoot(class_47 lootContext, Consumer<class_1799> consumer, Operation<Void> original) {
        LootCollector lootCollector = new LootCollector(consumer);
        original.call(lootContext, lootCollector);
        lootCollector.finish(this.tlm$getLootTableId(), lootContext);
    }

    @Mixin(class_52.class_53.class)
    public static class BuilderMixin implements ILootTableBuilder {
        @Unique
        private class_2960 tlm$id;

        @Override
        public void tlm$setId(class_2960 id) {
            this.tlm$id = id;
        }

        @ModifyReturnValue(method = "build", at = @At("RETURN"))
        private class_52 tlm$addId(class_52 table) {
            if (this.tlm$id != null)
                ((ILootTable) table).tlm$setLootTableId(this.tlm$id);
            return table;
        }
    }
}