package cn.sh1rocu.touhoulittlemaid.util.itemhandler;

import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class CombinedInvWrapper implements IItemHandlerModifiable {
    protected final IItemHandlerModifiable[] itemHandler; // the handlers
    protected final int[] baseIndex; // index-offsets of the different handlers
    protected final int slotCount; // number of total slots

    public CombinedInvWrapper(IItemHandlerModifiable... itemHandler) {
        this.itemHandler = itemHandler;
        this.baseIndex = new int[itemHandler.length];
        int index = 0;
        for (int i = 0; i < itemHandler.length; i++) {
            index += itemHandler[i].getSlots();
            baseIndex[i] = index;
        }
        this.slotCount = index;
    }

    // returns the handler index for the slot
    protected int getIndexForSlot(int slot) {
        if (slot < 0)
            return -1;

        for (int i = 0; i < baseIndex.length; i++) {
            if (slot - baseIndex[i] < 0) {
                return i;
            }
        }
        return -1;
    }

    protected IItemHandlerModifiable getHandlerFromIndex(int index) {
        if (index < 0 || index >= itemHandler.length) {
            return (IItemHandlerModifiable) EmptyItemHandler.INSTANCE;
        }
        return itemHandler[index];
    }

    protected int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= baseIndex.length) {
            return slot;
        }
        return slot - baseIndex[index - 1];
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        int index = getIndexForSlot(slot);
        IItemHandlerModifiable handler = getHandlerFromIndex(index);
        slot = getSlotFromIndex(slot, index);
        handler.setStackInSlot(slot, stack);
    }

    @Override
    public int getSlots() {
        return slotCount;
    }

    @Override
    public class_1799 getStackInSlot(int slot) {
        int index = getIndexForSlot(slot);
        IItemHandlerModifiable handler = getHandlerFromIndex(index);
        slot = getSlotFromIndex(slot, index);
        return handler.getStackInSlot(slot);
    }

    @Override
    public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        int index = getIndexForSlot(slot);
        IItemHandlerModifiable handler = getHandlerFromIndex(index);
        slot = getSlotFromIndex(slot, index);
        return handler.insertItem(slot, stack, simulate);
    }

    @Override
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        int index = getIndexForSlot(slot);
        IItemHandlerModifiable handler = getHandlerFromIndex(index);
        slot = getSlotFromIndex(slot, index);
        return handler.extractItem(slot, amount, simulate);
    }

    @Override
    public int getSlotLimit(int slot) {
        int index = getIndexForSlot(slot);
        IItemHandlerModifiable handler = getHandlerFromIndex(index);
        int localSlot = getSlotFromIndex(slot, index);
        return handler.getSlotLimit(localSlot);
    }

    @Override
    public boolean isItemValid(int slot, class_1799 stack) {
        int index = getIndexForSlot(slot);
        IItemHandlerModifiable handler = getHandlerFromIndex(index);
        int localSlot = getSlotFromIndex(slot, index);
        return handler.isItemValid(localSlot, stack);
    }

    public void readFromNbt(@NotNull class_2487 tag, class_7225.@NotNull class_7874 registryLookup) {
        if (tag.method_10545(TAG_INVENTORY)) {
            this.deserializeNBT(registryLookup, tag.method_10562(TAG_INVENTORY));
        }
    }

    @Override
    public void writeToNbt(@NotNull class_2487 tag, class_7225.@NotNull class_7874 registryLookup) {
        tag.method_10566(TAG_INVENTORY, this.serializeNBT(registryLookup));
    }

    public class_2487 serializeNBT(class_7225.class_7874 provider) {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < getSlots(); i++) {
            if (!getStackInSlot(i).method_7960()) {
                class_2487 itemTag = new class_2487();
                itemTag.method_10569("Slot", i);
                nbtTagList.add(getStackInSlot(i).method_57376(provider, itemTag));
            }
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", nbtTagList);
        nbt.method_10569("Size", getSlots());
        return nbt;
    }

    public void deserializeNBT(class_7225.class_7874 provider, class_2487 nbt) {
        int size = nbt.method_10573("Size", class_2520.field_33253) ? nbt.method_10550("Size") : getSlots();
        class_2499 tagList = nbt.method_10554("Items", class_2520.field_33260);
        for (int i = 0; i < tagList.size(); i++) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");

            if (slot >= 0 && slot < size) {
                class_1799.method_57360(provider, itemTags).ifPresent(stack -> setStackInSlot(slot, stack));
            }
        }
    }
}
