package com.github.tartaricacid.touhoulittlemaid.advancements.altar;

import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_175;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;

public class AltarCraftTrigger extends class_4558<AltarCraftTrigger.Instance> {
    public void trigger(class_3222 serverPlayer, class_2960 recipeId) {
        super.method_22510(serverPlayer, instance -> instance.matches(recipeId));
    }

    @Override
    public Codec<Instance> method_54937() {
        return Instance.CODEC;
    }

    public record Instance(Optional<class_5258> player,
                           class_2960 recipeId) implements SimpleInstance {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(instance -> instance.group(
                        class_2048.field_47250.optionalFieldOf("player").forGetter(Instance::player),
                        class_2960.field_25139.fieldOf("recipe_id").forGetter(Instance::recipeId))
                .apply(instance, Instance::new));

        public boolean matches(class_2960 recipeIdIn) {
            return this.recipeId.equals(recipeIdIn);
        }

        public static class_175<Instance> recipe(class_2960 recipeId) {
            return InitTrigger.ALTAR_CRAFT.method_53699(new Instance(Optional.empty(), recipeId));
        }
    }
}
