package com.github.tartaricacid.touhoulittlemaid.api.event;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1304;
import net.minecraft.class_1799;

public class MaidEquipEvent {
    private final EntityMaid maid;
    private final class_1304 slot;
    private final class_1799 stack;

    public MaidEquipEvent(EntityMaid maid, class_1304 slot, class_1799 stack) {
        this.maid = maid;
        this.slot = slot;
        this.stack = stack;
    }

    public EntityMaid getMaid() {
        return maid;
    }

    public class_1304 getSlot() {
        return slot;
    }

    public class_1799 getStack() {
        return stack;
    }

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.post(event);
        }
    });

    public interface Callback {
        void post(MaidEquipEvent event);
    }
}
