package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_3218;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_9062;

public abstract class BlockJoy extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;

    protected BlockJoy(class_4970.class_2251 properties) {
        super(properties);
    }

    public BlockJoy() {
        this(class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9626(class_2498.field_11547).method_9629(2.0F, 3.0F).method_51369().method_22488());
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
    }

    protected abstract class_243 sitPosition();

    protected abstract String getTypeName();

    protected abstract int sitYRot();

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Override
    public class_9062 method_55765(class_1799 itemStack, class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_1268 hand, class_3965 hit) {
        if (worldIn instanceof class_3218 serverLevel && playerIn.method_5998(hand).method_7960() && worldIn.method_8321(pos) instanceof TileEntityJoy joy) {
            class_1297 oldSitEntity = serverLevel.method_14190(joy.getSitId());
            if (oldSitEntity != null && oldSitEntity.method_5805()) {
                return super.method_55765(itemStack, state, worldIn, pos, playerIn, hand, hit);
            }
            EntitySit newSitEntity = new EntitySit(worldIn, class_243.method_49273(pos, this.sitPosition().field_1352, this.sitPosition().field_1351, this.sitPosition().field_1350), this.getTypeName(), pos);
            newSitEntity.method_36456(state.method_11654(FACING).method_10153().method_10144() + this.sitYRot());
            worldIn.method_8649(newSitEntity);
            joy.setSitId(newSitEntity.method_5667());
            joy.method_5431();
            playerIn.method_5804(newSitEntity);
            return class_9062.field_47728;
        }
        return super.method_55765(itemStack, state, worldIn, pos, playerIn, hand, hit);
    }

    public void startMaidSit(EntityMaid maid, class_2680 state, class_1937 worldIn, class_2338 pos) {
        if (worldIn instanceof class_3218 serverLevel && worldIn.method_8321(pos) instanceof TileEntityJoy joy) {
            class_1297 oldSitEntity = serverLevel.method_14190(joy.getSitId());
            if (oldSitEntity != null && oldSitEntity.method_5805()) {
                return;
            }
            EntitySit newSitEntity = new EntitySit(worldIn, class_243.method_49273(pos, this.sitPosition().field_1352, this.sitPosition().field_1351, this.sitPosition().field_1350), this.getTypeName(), pos);
            newSitEntity.method_36456(state.method_11654(FACING).method_10153().method_10144() + this.sitYRot());
            worldIn.method_8649(newSitEntity);
            joy.setSitId(newSitEntity.method_5667());
            joy.method_5431();
            maid.method_5804(newSitEntity);
        }
    }

    @Override
    public void method_9536(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 newState, boolean isMoving) {
        class_2586 blockEntity = worldIn.method_8321(pos);
        if (blockEntity instanceof TileEntityJoy joy && worldIn instanceof class_3218 serverLevel) {
            class_1297 entity = serverLevel.method_14190(joy.getSitId());
            if (entity instanceof EntitySit) {
                entity.method_31472();
            }
        }
        super.method_9536(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        return this.method_9564().method_11657(FACING, context.method_8042().method_10153());
    }

    @Override
    public boolean method_9516(class_2680 state, class_10 type) {
        return true;
    }

    @Override
    public class_2464 method_9604(class_2680 pState) {
        return class_2464.field_11456;
    }
}
