package com.github.tartaricacid.touhoulittlemaid.client.gui.block;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache.CacheIconManager;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.DirectButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ImageButtonWithId;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouImageButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SaveSwitcherDataPackage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import java.util.List;
import java.util.UUID;

public class ModelSwitcherGui extends class_437 {
    private static final class_2960 BG = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/model_switcher.png");
    private static final class_2960 DEFAULT_MODEL_ID = class_2960.method_60654("touhou_little_maid:hakurei_reimu");
    private final List<TileEntityModelSwitcher.ModeInfo> infoList;
    private final class_2338 pos;
    private final int maxRow = 6;
    private final UUID bindUuid;
    protected int imageWidth = 256;
    protected int imageHeight = 166;
    protected int leftPos;
    protected int topPos;
    private EntityMaid maid = null;
    private class_342 description;
    private int selectedIndex = -1;
    private int page;

    public ModelSwitcherGui(TileEntityModelSwitcher switcher) {
        super(class_2561.method_43470("Model Switcher GUI"));
        this.infoList = switcher.getInfoList();
        this.pos = switcher.method_11016();
        this.bindUuid = switcher.getUuid();
        if (class_310.method_1551().field_1687 != null) {
            this.maid = new EntityMaid(class_310.method_1551().field_1687);
        }
    }

    @Override
    protected void method_25426() {
        this.method_37067();

        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.selectedIndex = selectedIndex < infoList.size() ? selectedIndex : -1;
        this.page = page <= (infoList.size() - 1) / maxRow ? page : 0;

        this.addListChangeButton();
        this.addPageButton();
        this.addListButton();
        if (selectedIndex >= 0) {
            this.addEditButton();
        } else {
            this.description = null;
        }
    }

    private void addEditButton() {
        TileEntityModelSwitcher.ModeInfo info = this.infoList.get(selectedIndex);
        maid.setModelId(info.getModelId().toString());

        this.method_37063(class_4185.method_46430(class_2561.method_43471("gui.touhou_little_maid.button.skin"), b -> CacheIconManager.openModelSwitcherModelGui(maid, info, this))
                .method_46433(leftPos + 55, topPos + 15).method_46437(76, 20).method_46431());

        this.method_37063(new DirectButton(leftPos + 55, topPos + 38, 76, 20, info.getDirection(),
                b -> info.setDirection(((DirectButton) b).getDirection())));

        this.method_37063(class_4185.method_46430(class_2561.method_43471("selectWorld.edit.save"), b -> {
            ClientPlayNetworking.send(new SaveSwitcherDataPackage(pos, this.infoList));
        }).method_46433(leftPos + 12, topPos + 135).method_46437(121, 20).method_46431());

        this.description = new class_342(Screens.getTextRenderer(this), leftPos + 12, topPos + 65, 119, 20,
                class_2561.method_43471("gui.touhou_little_maid.name_tag.edit_box"));
        this.description.method_1852(info.getText());
        this.method_25429(this.description);
        this.method_48265(this.description);
    }

    private void addListButton() {
        int startOffsetY = topPos + 24;
        for (int i = page * maxRow; i < Math.min(infoList.size(), (page + 1) * maxRow); i++) {
            ImageButtonWithId button;
            if (i != selectedIndex) {
                button = new ImageButtonWithId(i, leftPos + 141, startOffsetY, 108, 19, 0, 166, 19, BG, b -> {
                    selectedIndex = ((ImageButtonWithId) b).getIndex();
                    this.method_25426();
                });
            } else {
                button = new ImageButtonWithId(i, leftPos + 141, startOffsetY, 108, 19, 108, 166, 0, BG, b -> {
                    selectedIndex = -1;
                    this.method_25426();
                });
            }
            this.method_37063(button);
            startOffsetY += 19;
        }
    }

    private void addPageButton() {
        this.method_37063(new TouhouImageButton(leftPos + 141, topPos + 7, 13, 16, 0, 204, 16, BG, b -> {
            if (page > 0) {
                page = page - 1;
                this.method_25426();
            }
        }));
        this.method_37063(new TouhouImageButton(leftPos + 236, topPos + 7, 13, 16, 13, 204, 16, BG, b -> {
            if ((page + 1) <= (infoList.size() - 1) / maxRow) {
                page = page + 1;
                this.method_25426();
            }
        }));
    }

    private void addListChangeButton() {
        this.method_37063(class_4185.method_46430(class_2561.method_43471("gui.touhou_little_maid.model_switcher.list.add"), b -> {
            this.infoList.add(new TileEntityModelSwitcher.ModeInfo(DEFAULT_MODEL_ID, "", class_2350.field_11043));
            this.method_25426();
        }).method_46433(leftPos + 141, topPos + 139).method_46437(53, 20).method_46431());

        this.method_37063(class_4185.method_46430(class_2561.method_43471("selectWorld.deleteButton"), b -> {
            if (-1 < selectedIndex && selectedIndex < this.infoList.size()) {
                this.infoList.remove(selectedIndex);
                selectedIndex = -1;
                this.method_25426();
            }
        }).method_46433(leftPos + 196, topPos + 139).method_46437(53, 20).method_46431());
    }

    @Override
    public void method_25410(class_310 pMinecraft, int pWidth, int pHeight) {
        String value = "";
        if (this.description != null) {
            value = this.description.method_1882();
        }
        super.method_25410(pMinecraft, pWidth, pHeight);
        if (this.description != null) {
            this.description.method_1852(value);
        }
    }

    @Override
    public void method_25394(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.maid == null) {
            return;
        }
        this.method_25420(graphics, pMouseX, pMouseY, pPartialTick);
        graphics.method_25302(BG, leftPos, topPos, 0, 0, imageWidth, imageHeight);
        if (bindUuid != null) {
            graphics.method_25300(field_22793, bindUuid.toString(), leftPos + 128, topPos - 10, 0xffffff);
        } else {
            graphics.method_27534(field_22793, class_2561.method_43471("gui.touhou_little_maid.model_switcher.uuid.empty"), leftPos + 128, topPos - 10, 0xffffff);
        }
        graphics.method_25300(field_22793, String.format("%d/%d", page + 1, (infoList.size() - 1) / maxRow + 1), leftPos + 193, topPos + 12, 0xffffff);
        if (this.description != null) {
            class_490.method_2486(
                    graphics,
                    leftPos + 9,
                    topPos + 8,
                    leftPos + 54,
                    topPos + 68,
                    24,
                    0.1F,
                    leftPos + 45,
                    topPos + 45,
                    maid);
            this.description.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
        }
        for (class_4068 renderable : ((ScreenAccessor) this).tlm$getRenderables()) {
            renderable.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
        }
        this.renderListButtonName(graphics);
    }

    private void renderListButtonName(class_332 graphics) {
        int startOffsetY = topPos + 29;
        for (int i = page * maxRow; i < Math.min(infoList.size(), (page + 1) * maxRow); i++) {
            String modelId = infoList.get(i).getModelId().toString();
            if (CustomPackLoader.MAID_MODELS.getInfo(modelId).isPresent()) {
                MaidModelInfo info = CustomPackLoader.MAID_MODELS.getInfo(modelId).get();
                class_5250 component = class_2561.method_43471(ParseI18n.getI18nKey(info.getName()));
                graphics.method_27534(field_22793, component, leftPos + 193, startOffsetY, 0xffffff);
            }
            startOffsetY += 19;
        }
    }

    @Override
    public void method_25393() {
        if (this.description != null) {
            if (0 <= selectedIndex && selectedIndex < infoList.size()) {
                infoList.get(selectedIndex).setText(description.method_1882());
            }
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.description != null && this.description.method_25402(mouseX, mouseY, button)) {
            this.method_25395(this.description);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    protected void method_25415(String text, boolean overwrite) {
        if (this.description != null) {
            if (overwrite) {
                this.description.method_1852(text);
            } else {
                this.description.method_1867(text);
            }
        }
    }

    @Override
    public void method_25419() {
        ClientPlayNetworking.send(new SaveSwitcherDataPackage(pos, this.infoList));
        super.method_25419();
    }
}
