package com.github.tartaricacid.touhoulittlemaid.client.gui.entity;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.download.InfoGetManager;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.GuiDownloadButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.PackInfoButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenMaidGuiPackage;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_407;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_7919;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.nio.file.*;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.*;

public class ModelDownloadGui extends class_437 {
    private static final class_2960 BG = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/download_background.png");
    private static final String PACK_FILE_SUFFIX = ".zip";
    private final Map<Long, String> crc32Infos = Maps.newHashMap();
    private final List<DownloadInfo> showInfos = Lists.newArrayList();
    private final EntityMaid maid;
    private Condition condition = Condition.ALL;
    private class_342 textField;
    private boolean needReload = false;
    private int selectIndex = -1;
    private int currentPage;
    private int x;
    private int y;

    public ModelDownloadGui(EntityMaid maid) {
        super(class_2561.method_43470("New Model Pack Download GUI"));
        this.getCrc32Infos();
        this.checkDownloadInfo();
        this.maid = maid;
    }

    @Override
    protected void method_25426() {
        this.method_37067();
        this.x = (field_22789 - 420) / 2;
        this.y = (field_22790 - 240) / 2;
        this.initShowInfos();
        this.addBaseButtons();
        this.addPackButtons();
        this.addPageButtons();
        this.addPackHandleButtons();
        this.addSearchBox();
    }

    private void addSearchBox() {
        String textCache = textField == null ? "" : textField.method_1882();
        boolean focus = textField != null && textField.method_25370();
        textField = new class_342(Screens.getTextRenderer(this), x + 273, y + 78, 144, 16, class_2561.method_43473());
        textField.method_1868(0xF3EFE0);
        textField.method_25365(focus);
        textField.method_1852(textCache);
        textField.method_1872(class_437.method_25442());
        this.method_25429(this.textField);
    }

    private void addPackHandleButtons() {
        if (0 <= this.selectIndex && this.selectIndex < this.showInfos.size()) {
            DownloadInfo info = this.showInfos.get(this.selectIndex);
            this.method_37063(new FlatColorButton(x + 272, y + 50, 20, 20, class_2561.method_43473(), b -> openPackWebsite(info))
                    .setTooltips("gui.touhou_little_maid.resources_download.open_link"));
            this.method_37063(new GuiDownloadButton(x + 294, y + 50, 102, 20, info, b -> {
                if (info.getStatus() == DownloadStatus.NOT_DOWNLOAD) {
                    info.setStatus(DownloadStatus.DOWNLOADING);
                    InfoGetManager.downloadPack(info);
                    this.method_25426();
                } else if (info.getStatus() == DownloadStatus.NEED_UPDATE) {
                    this.updatePack(info);
                }
            }));
            this.method_37063(new FlatColorButton(x + 398, y + 50, 20, 20, class_2561.method_43473(), b -> deletePack(info))
                    .setTooltips("gui.touhou_little_maid.resources_download.delete"));
        }
    }

    private void addPageButtons() {
        this.method_37063(new FlatColorButton(x, y + 218, 40, 20, class_2561.method_43470("<"), b -> {
            if (this.currentPage > 0) {
                this.currentPage--;
                this.method_25426();
            }
        }));
        this.method_37063(new FlatColorButton(x + 228, y + 218, 40, 20, class_2561.method_43470(">"), b -> {
            if ((this.currentPage * 4 + 4) <= this.showInfos.size()) {
                this.currentPage++;
                this.method_25426();
            }
        }));
    }

    private void addPackButtons() {
        int startIndex = currentPage * 4;
        for (int i = startIndex; i < startIndex + 4; i++) {
            if (i >= this.showInfos.size()) {
                break;
            }
            DownloadInfo info = this.showInfos.get(i);
            int yOffset = y + 26 + (i - startIndex) * 48;
            final int tmp = i;
            PackInfoButton button = new PackInfoButton(x, yOffset, info, b -> {
                this.selectIndex = tmp;
                this.method_25426();
            });
            if (this.selectIndex == i) {
                button.setSelect(true);
            }
            this.method_37063(button);
        }
    }

    private void addBaseButtons() {
        int i = 0;
        for (Condition c : Condition.values()) {
            int width = 52;
            int xPos = x + (width + 2) * i;
            String key = c.name().toLowerCase(Locale.US);
            String nameKey = "gui.touhou_little_maid.resources_download." + key;
            String descKey = nameKey + ".tips";
            class_4185 button = class_4185.method_46430(class_2561.method_43471(nameKey), b -> setCondition(c)).method_46437(width, 20)
                    .method_46433(xPos, y + 3).method_46436(class_7919.method_47407(class_2561.method_43471(descKey))).method_46431();
            if (this.condition.equals(c)) {
                button.field_22763 = false;
            }
            this.method_37063(button);
            i++;
        }
        this.method_37063(new FlatColorButton(x + 400, y + 2, 20, 20, class_2561.method_43473(),
                b -> {
                    if (this.maid != null) {
                        ClientPlayNetworking.send(new OpenMaidGuiPackage(this.maid.method_5628()));
                    }
                }).setTooltips("gui.touhou_little_maid.skin.button.close"));
        this.method_37063(class_4185.method_46430(class_2561.method_43471("gui.touhou_little_maid.resources_download.open_folder"), b -> class_156.method_668().method_672(CustomPackLoader.PACK_FOLDER.toFile()))
                .method_46433(x + 270, y + 218).method_46437(150, 20).method_46431());
    }

    private void initShowInfos() {
        this.showInfos.clear();

        switch (this.condition) {
            case MAID -> this.showInfos.addAll(InfoGetManager.getTypedDownloadInfoList(DownloadInfo.TypeEnum.MAID));
            case CHAIR -> this.showInfos.addAll(InfoGetManager.getTypedDownloadInfoList(DownloadInfo.TypeEnum.CHAIR));
            case SOUND -> this.showInfos.addAll(InfoGetManager.getTypedDownloadInfoList(DownloadInfo.TypeEnum.SOUND));
            case UPDATE -> this.showInfos.addAll(InfoGetManager.DOWNLOAD_INFO_LIST_ALL.stream()
                    .filter(info -> info.getStatus() == DownloadStatus.NEED_UPDATE).toList());
            default -> this.showInfos.addAll(InfoGetManager.DOWNLOAD_INFO_LIST_ALL);
        }

        if (textField != null && StringUtils.isNotBlank(textField.method_1882())) {
            String search = this.textField.method_1882().toLowerCase(Locale.US);
            this.showInfos.removeIf(info -> !info.getKeyword().contains(search));
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float pPartialTick) {
        super.method_57734(pPartialTick);
        this.renderBase(graphics);
        this.renderSearchBox(graphics, mouseX, mouseY, pPartialTick);
        this.renderPageNumber(graphics);
        for (class_4068 renderable : ((ScreenAccessor) this).tlm$getRenderables()) {
            renderable.method_25394(graphics, mouseX, mouseY, pPartialTick);
        }
        this.renderBaseButtons(graphics);
        this.renderPackHandleButtons(graphics);
        this.renderNoDataTips(graphics);
        ((ScreenAccessor) this).tlm$getRenderables().stream().filter(b -> b instanceof FlatColorButton).forEach(b -> ((FlatColorButton) b).renderToolTip(graphics, this, mouseX, mouseY));
    }

    private void renderNoDataTips(class_332 graphics) {
        if (!InfoGetManager.DOWNLOAD_INFO_LIST_ALL.isEmpty()) {
            return;
        }
        List<class_5481> split = field_22793.method_1728(class_2561.method_43471("gui.touhou_little_maid.resources_download.fail"), 200);
        int yOffset = y + 100;
        for (class_5481 sequence : split) {
            graphics.method_35719(field_22793, sequence, x + 134, yOffset, class_124.field_1061.method_532());
            yOffset += 12;
        }
    }

    private void renderPageNumber(class_332 graphics) {
        int maxPage = (this.showInfos.size() - 1) / 4;
        String pageInfo = String.format("%d/%d", currentPage + 1, maxPage + 1);
        graphics.method_25303(field_22793, pageInfo, x + 134 - field_22793.method_1727(pageInfo) / 2, y + 227 - field_22793.field_2000 / 2, 0xF3EFE0);
    }

    private void renderPackHandleButtons(class_332 graphics) {
        if (0 <= this.selectIndex && this.selectIndex < this.showInfos.size()) {
            DownloadInfo info = this.showInfos.get(this.selectIndex);
            graphics.method_27534(field_22793, class_2561.method_43471(info.getName()), x + 345, y + 34, 0xffffff);
            graphics.method_25302(BG, x + 400, y + 52, 0, 16, 16, 16);
            graphics.method_25302(BG, x + 274, y + 52, 16, 16, 16, 16);
        }
    }

    private void renderBaseButtons(class_332 graphics) {
        graphics.method_25302(BG, x + 402, y + 4, 32, 16, 16, 16);
    }

    private void renderSearchBox(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        graphics.method_27535(field_22793, class_2561.method_43471("gui.touhou_little_maid.resources_download.hot_search"), x + 274, y + 102, 0xffffff);
        graphics.method_51440(field_22793, class_2561.method_43471("gui.touhou_little_maid.resources_download.hot_search_key"), x + 274, y + 115, 146, class_124.field_1080.method_532());
        textField.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
        if (textField.method_1882().isEmpty() && !textField.method_25370()) {
            graphics.method_27535(field_22793, class_2561.method_43471("gui.touhou_little_maid.resources_download.search").method_27692(class_124.field_1056), x + 277, y + 83, 0x777777);
        }
    }

    private void renderBase(class_332 graphics) {
        graphics.method_25296(0, 0, this.field_22789, this.field_22790, 0xe2_000000, 0xe2_000000);
        graphics.method_25296(x + 270, y + 26, x + 420, y + 72, 0xff_232221, 0xff_232221);
        graphics.method_25296(x + 270, y + 74, x + 420, y + 216, 0xff_232221, 0xff_232221);
    }

    @Override
    public void method_25410(class_310 minecraft, int width, int height) {
        String value = this.textField.method_1882();
        super.method_25410(minecraft, width, height);
        this.textField.method_1852(value);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.textField.method_25402(mouseX, mouseY, button)) {
            this.method_25395(this.textField);
            return true;
        } else if (this.textField.method_25370()) {
            this.textField.method_25365(false);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25400(char codePoint, int modifiers) {
        if (textField == null) {
            return false;
        }
        String perText = this.textField.method_1882();
        if (this.textField.method_25400(codePoint, modifiers)) {
            if (!Objects.equals(perText, this.textField.method_1882())) {
                this.currentPage = 0;
                this.method_25426();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean hasKeyCode = class_3675.method_15985(keyCode, scanCode).method_30103().isPresent();
        String preText = this.textField.method_1882();
        if (hasKeyCode) {
            return true;
        }
        if (this.textField.method_25404(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(preText, this.textField.method_1882())) {
                this.currentPage = 0;
                this.method_25426();
            }
            return true;
        } else {
            return this.textField.method_25370() && this.textField.method_1885() && keyCode != 256 || super.method_25404(keyCode, scanCode, modifiers);
        }
    }

    @Override
    protected void method_25415(String text, boolean overwrite) {
        if (overwrite) {
            this.textField.method_1852(text);
        } else {
            this.textField.method_1867(text);
        }
    }

    @Override
    public void method_25419() {
        if (this.needReload && Screens.getClient(this).field_1724 != null) {
            Screens.getClient(this).field_1705.method_34004(class_2561.method_43471("gui.touhou_little_maid.resources_download.need_reload.title"));
            Screens.getClient(this).field_1705.method_34002(class_2561.method_43471("gui.touhou_little_maid.resources_download.need_reload.subtitle"));
            Screens.getClient(this).field_1724.method_43496(class_2561.method_43471("gui.touhou_little_maid.resources_download.need_reload.subtitle"));
        }
        super.method_25419();
    }

    private void getCrc32Infos() {
        this.crc32Infos.clear();
        try {
            Files.walkFileTree(CustomPackLoader.PACK_FOLDER, EnumSet.noneOf(FileVisitOption.class), 1, new SimpleFileVisitor<Path>() {
                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(PACK_FILE_SUFFIX)) {
                        crc32Infos.put(FileUtils.checksumCRC32(file.toFile()), file.toFile().getName());
                    }
                    return super.visitFile(file, attrs);
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkDownloadInfo() {
        for (DownloadInfo info : InfoGetManager.DOWNLOAD_INFO_LIST_ALL) {
            if (info.getStatus() != DownloadStatus.DOWNLOADING) {
                info.setStatus(DownloadStatus.NOT_DOWNLOAD);
            }
            for (Long crc32 : this.crc32Infos.keySet()) {
                if (crc32.equals(info.getChecksum())) {
                    info.setStatus(DownloadStatus.DOWNLOADED);
                    break;
                }
                if (info.getOldVersion().contains(crc32)) {
                    info.setStatus(DownloadStatus.NEED_UPDATE);
                    break;
                }
            }
        }
    }

    private void setCondition(Condition condition) {
        if (this.condition != condition) {
            this.condition = condition;
            this.currentPage = 0;
            this.method_25426();
        }
    }

    private void openPackWebsite(DownloadInfo info) {
        String website = info.getWebsite();
        if (StringUtils.isNotBlank(website)) {
            Screens.getClient(this).method_1507(new class_407(yes -> {
                if (yes) {
                    class_156.method_668().method_670(website);
                }
                Screens.getClient(this).method_1507(this);
            }, website, false));
        }
    }

    private void deletePack(DownloadInfo info) {
        Set<String> deleteFiles = this.getDeleteFiles(info);
        if (info.getStatus() == DownloadStatus.DOWNLOADED || info.getStatus() == DownloadStatus.NEED_UPDATE) {
            Screens.getClient(this).method_1507(new class_410(yes -> this.deleteFilesAndReload(yes, deleteFiles),
                    class_2561.method_43471("gui.touhou_little_maid.resources_download.delete.confirm"),
                    class_2561.method_43471(info.getName())));
        }
    }

    private void updatePack(DownloadInfo info) {
        Set<String> deleteFiles = this.getDeleteFiles(info);
        this.deleteFiles(deleteFiles);
        info.setStatus(DownloadStatus.DOWNLOADING);
        InfoGetManager.downloadPack(info);
        this.needReload = true;
        this.getCrc32Infos();
        this.checkDownloadInfo();
        this.method_25426();
    }

    @NotNull
    private Set<String> getDeleteFiles(DownloadInfo info) {
        Set<String> deleteFiles = Sets.newHashSet();
        deleteFiles.add(info.getFileName());
        info.getOldVersion().forEach(version -> {
            if (crc32Infos.containsKey(version)) {
                deleteFiles.add(crc32Infos.get(version));
            }
        });
        return deleteFiles;
    }

    private void deleteFiles(Set<String> deleteFiles) {
        for (String fileName : deleteFiles) {
            try {
                Path file = CustomPackLoader.PACK_FOLDER.resolve(fileName);
                if (Files.isRegularFile(file)) {
                    Files.delete(file);
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void deleteFilesAndReload(boolean yes, Set<String> deleteFiles) {
        if (yes) {
            this.deleteFiles(deleteFiles);
            this.needReload = true;
            this.getCrc32Infos();
            this.checkDownloadInfo();
            this.method_25426();
        }
        Screens.getClient(this).method_1507(this);
    }

    public enum Condition {
        ALL, MAID, CHAIR, SOUND, UPDATE
    }
}
