package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.sound.pojo.SoundPackInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.mojang.blaze3d.systems.RenderSystem;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import net.minecraft.class_1044;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_757;

public class SoundPackButton extends FlatColorButton {
    private static final class_2960 ICON = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/maid_custom_sound.png");
    private final SoundPackInfo info;
    private boolean isUse = false;

    public SoundPackButton(int pX, int pY, SoundPackInfo info, class_4241 onPress) {
        super(pX, pY, 230, 43, class_2561.method_43473(), onPress);
        this.info = info;
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float pPartialTick) {
        super.method_48579(graphics, mouseX, mouseY, pPartialTick);
        class_2960 icon = info.getIcon();
        if (icon == null) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture(0, ICON);
            graphics.method_25290(ICON, this.method_46426() + 4, this.method_46427() + 5, 0, 16, 32, 32, 256, 256);
        } else {
            if (info.getIconAnimation() == CustomModelPack.AnimationState.UNCHECK) {
                checkIconAnimation(info, icon);
            }
            if (info.getIconAnimation() == CustomModelPack.AnimationState.FALSE) {
                graphics.method_25290(icon, this.method_46426() + 4, this.method_46427() + 5,
                        0, 0, 32, 32, 32, 32);
            } else {
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderTexture(0, icon);
                int time = getTickTime() / info.getIconDelay();
                int iconIndex = time % info.getIconAspectRatio();
                graphics.method_25290(icon, this.method_46426() + 4, this.method_46427() + 5,
                        0, iconIndex * 32, 32,
                        32, 32, 32 * info.getIconAspectRatio());
            }
        }
        if (isUse) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture(0, ICON);
            graphics.method_25290(ICON, this.method_46426() + this.method_25368() - 20, this.method_46427() + 13, 32, 0, 16, 16, 256, 256);
        }
    }

    @Override
    @SuppressWarnings("all")
    public void method_48589(class_332 graphics, class_327 font, int pColor) {
        int startX = this.method_46426() + 42;
        int startY = this.method_46427() + 7;

        class_5250 packName = ParseI18n.parse(info.getPackName());
        String version = info.getVersion();
        List<String> author = info.getAuthor();
        String date = info.getDate();

        graphics.method_27535(font, packName, startX, startY, class_124.field_1068.method_532());

        if (StringUtils.isNotBlank(version)) {
            int titleWidth = font.method_27525(packName);
            graphics.method_25303(font, "§nv" + version, startX + titleWidth + 5, startY, class_124.field_1075.method_532());
        }

        if (!author.isEmpty()) {
            startY += 10;
            String authorListText = StringUtils.joinWith(class_1074.method_4662("gui.touhou_little_maid.resources_download.author.delimiter"), author);
            String authorText = class_1074.method_4662("gui.touhou_little_maid.resources_download.author", authorListText);
            graphics.method_25303(font, authorText, startX, startY, class_124.field_1065.method_532());
        }

        if (StringUtils.isNotBlank(date)) {
            startY += 10;
            class_5250 dateText = class_2561.method_43469("gui.touhou_little_maid.skin.text.date", date);
            graphics.method_27535(font, dateText, startX, startY, class_124.field_1060.method_532());
        }
    }

    private int getTickTime() {
        return (int) System.currentTimeMillis() / 50;
    }

    private void checkIconAnimation(SoundPackInfo info, class_2960 icon) {
        class_1044 iconText = class_310.method_1551().method_1531().method_4619(icon);
        if (iconText instanceof SizeTexture) {
            int width = ((SizeTexture) iconText).getWidth();
            int height = ((SizeTexture) iconText).getHeight();
            if (width >= height) {
                info.setIconAnimation(CustomModelPack.AnimationState.FALSE);
            } else {
                info.setIconAnimation(CustomModelPack.AnimationState.TRUE);
                info.setIconAspectRatio(height / width);
            }
        } else {
            info.setIconAnimation(CustomModelPack.AnimationState.FALSE);
        }
    }

    public boolean isUse() {
        return isUse;
    }

    public void setUse(boolean use) {
        isUse = use;
    }
}
