package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBox;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;

import static com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader.CAKE_BOX;

public class EntityBoxRender extends class_897<EntityBox> {
    private final List<class_2960> texturesGroup = Lists.newArrayList();
    private final SimpleBedrockModel<EntityBox> boxModel;

    public EntityBoxRender(class_5617.class_5618 manager) {
        super(manager);
        boxModel = BedrockModelLoader.getModel(CAKE_BOX);
        IntStream.range(0, EntityBox.MAX_TEXTURE_SIZE).forEach(this::addBoxTexture);
    }

    @Override
    public void render(EntityBox entityBox, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int packedLight) {
        poseStack.method_22903();
        poseStack.method_22905(-1.0F, -1.0F, 1.0F);
        poseStack.method_22904(0.0, -1.501, 0.0);
        boxModel.method_2819(entityBox, 0, 0, -0.1f, 0, 0);
        class_1921 renderType = class_1921.method_23578(getTextureLocation(entityBox));
        class_4588 buffer = bufferIn.getBuffer(renderType);
        boxModel.method_60879(poseStack, buffer, packedLight, class_4608.field_21444);
        poseStack.method_22909();
    }

    @Override
    public class_2960 getTextureLocation(EntityBox entity) {
        return texturesGroup.get(entity.getTextureIndex());
    }

    private void addBoxTexture(int index) {
        String fileName = String.format("textures/bedrock/entity/cake_box/cake_box_%s.png", index);
        texturesGroup.add(class_2960.method_60655(TouhouLittleMaid.MOD_ID, fileName));
    }
}