package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.SimpleBedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import org.joml.Matrix4f;

import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;

import static com.github.tartaricacid.touhoulittlemaid.client.resource.BedrockModelLoader.TOMBSTONE;

public class EntityTombstoneRenderer extends class_897<EntityTombstone> {
    private static final class_2960 DEFAULT_TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/bedrock/entity/tombstone/tombstone_overworld.png");
    private static final class_2960 THE_NETHER_TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/bedrock/entity/tombstone/tombstone_the_nether.png");
    private static final class_2960 THE_END_TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/bedrock/entity/tombstone/tombstone_the_end.png");
    private static final class_2960 TWILIGHT_FOREST_TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/bedrock/entity/tombstone/tombstone_twilight_forest.png");
    private static final class_2960 AETHER_TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/bedrock/entity/tombstone/tombstone_aether.png");

    private static final class_2960 TWILIGHT_FOREST_LEVEL_ID = class_2960.method_60655("twilightforest", "twilight_forest");
    private final static class_2960 AETHER_LEVEL_ID = class_2960.method_60655("aether", "the_aether");

    private static final int NAME_SHOW_DISTANCE = 64;
    private final SimpleBedrockModel<EntityTombstone> tombstoneModel;

    public EntityTombstoneRenderer(class_5617.class_5618 manager) {
        super(manager);
        tombstoneModel = Objects.requireNonNull(BedrockModelLoader.getModel(TOMBSTONE));
    }

    @Override
    public void render(EntityTombstone tombstone, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int packedLight) {
        poseStack.method_22903();
        poseStack.method_22905(-1.0F, -1.0F, 1.0F);
        poseStack.method_22904(0.0, -1.501, 0.0);
        tombstoneModel.method_2819(tombstone, 0, 0, -0.1f, 0, 0);
        class_1921 renderType = class_1921.method_23578(getTextureLocation(tombstone));
        class_4588 buffer = bufferIn.getBuffer(renderType);
        tombstoneModel.method_60879(poseStack, buffer, packedLight, class_4608.field_21444);
        poseStack.method_22909();
        if (this.shouldShowName(tombstone)) {
            this.renderNameTag(tombstone, class_2561.method_43471("entity.touhou_little_maid.tombstone.display").method_27695(class_124.field_1065, class_124.field_1073), 1.6f, poseStack, bufferIn, packedLight);
            this.renderNameTag(tombstone, tombstone.getMaidName(), 1.85f, poseStack, bufferIn, packedLight);
        }
    }

    @Override
    protected boolean shouldShowName(EntityTombstone tombstone) {
        return !tombstone.getMaidName().equals(class_2561.method_43473());
    }

    @Override
    public class_2960 getTextureLocation(EntityTombstone entity) {
        class_2960 dimension = entity.field_6002.method_27983().method_29177();
        if (dimension.equals(class_1937.field_25180.method_29177())) {
            return THE_NETHER_TEXTURE;
        }
        if (dimension.equals(class_1937.field_25181.method_29177())) {
            return THE_END_TEXTURE;
        }
        if (dimension.equals(TWILIGHT_FOREST_LEVEL_ID)) {
            return TWILIGHT_FOREST_TEXTURE;
        }
        if (dimension.equals(AETHER_LEVEL_ID)) {
            return AETHER_TEXTURE;
        }
        return DEFAULT_TEXTURE;
    }

    private void renderNameTag(EntityTombstone tombstone, class_2561 component, float yOffset, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        double distance = this.field_4676.method_23168(tombstone);
        if (distance < (NAME_SHOW_DISTANCE * NAME_SHOW_DISTANCE)) {
            poseStack.method_22903();
            poseStack.method_46416(0.0F, yOffset, 0.0F);
            poseStack.method_22907(this.field_4676.method_24197());
            poseStack.method_22905(-0.025F, -0.025F, 0.025F);
            Matrix4f matrix4f = poseStack.method_23760().method_23761();
            class_327 font = this.method_3932();
            float width = (float) (-font.method_27525(component) / 2);
            font.method_30882(component, width, 0, -1, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, packedLight);
            poseStack.method_22909();
        }
    }
}