package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.implement;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.EntityGraphics;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_5481;

public class ProgressChatBubbleRenderer implements IChatBubbleRenderer {
    private static final int MAX_WIDTH = 240;

    private final class_327 font;
    private final class_2960 bg;
    private final List<class_5481> split;
    private final int barBackgroundColor;
    private final int barForegroundColor;
    private final double progress;
    private final boolean alignCenter;
    private final int width;
    private final int height;

    public ProgressChatBubbleRenderer(class_2960 bg, class_2561 text, int barBackgroundColor, int barForegroundColor,
                                      double progress, boolean alignCenter) {
        this.font = class_310.method_1551().field_1772;
        this.bg = bg;
        this.split = font.method_1728(text, MAX_WIDTH);
        this.barBackgroundColor = barBackgroundColor;
        this.barForegroundColor = barForegroundColor;
        this.progress = class_3532.method_15350(progress, 0d, 1d);
        this.alignCenter = alignCenter;
        this.width = class_3532.method_15340(font.method_27525(text), 100, MAX_WIDTH);
        this.height = split.size() * font.field_2000 + 12;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void render(EntityMaidRenderer renderer, EntityGraphics graphics) {
        int y = 0;
        for (class_5481 sequence : this.split) {
            if (this.alignCenter) {
                int distance = this.width - font.method_30880(sequence);
                graphics.drawString(font, sequence, distance / 2, y, 0x000000, false);
            } else {
                graphics.drawString(font, sequence, 0, y, 0x000000, false);
            }
            y += font.field_2000;
        }
        y += 2;
        int margin = 1;
        int barHeight = 10;
        graphics.fill(0, y, this.width, y + barHeight, this.barBackgroundColor);
        if (this.progress > 0) {
            int barWidth = (int) ((this.width - 2 * margin) * this.progress);
            graphics.getPoseStack().method_22904(0, 0, -0.01);
            graphics.fill(margin, y + margin, barWidth, y + barHeight - margin, this.barForegroundColor);
        }
    }

    @Override
    public class_2960 getBackgroundTexture() {
        return this.bg;
    }
}