package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.implement;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.EntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.EntityGraphics;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5481;
import java.util.List;

@Environment(EnvType.CLIENT)
public class TextChatBubbleRenderer implements IChatBubbleRenderer {
    private static final int MAX_WIDTH = 240;
    private static final int MAX_CENTER_WIDTH = 480;

    private final List<class_5481> split;
    private final class_327 font;
    private final int width;
    private final int height;
    private final class_2960 bg;

    public TextChatBubbleRenderer(class_2561 text, class_2960 bg, IChatBubbleRenderer.Position position) {
        this.font = class_310.method_1551().field_1772;
        if (position == Position.CENTER) {
            this.split = font.method_1728(text, MAX_CENTER_WIDTH);
            this.width = getMaxWidth(split);
        } else {
            this.split = font.method_1728(text, MAX_WIDTH);
            this.width = getMaxWidth(split);
        }
        this.height = split.size() * font.field_2000;
        this.bg = bg;
    }

    private int getMaxWidth(List<class_5481> split) {
        int width = 0;
        for (class_5481 sequence : split) {
            int lineWidth = font.method_30880(sequence);
            if (lineWidth > width) {
                width = lineWidth;
            }
        }
        return width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void render(EntityMaidRenderer renderer, EntityGraphics graphics) {
        int y = 0;
        for (class_5481 sequence : this.split) {
            graphics.drawString(font, sequence, 0, y, 0x000000, false);
            y += font.field_2000;
        }
    }

    @Override
    public class_2960 getBackgroundTexture() {
        return this.bg;
    }
}