package com.github.tartaricacid.touhoulittlemaid.compat.tacz.client;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.tacz.guns.api.item.IGun;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import javax.annotation.Nullable;

import static com.github.tartaricacid.touhoulittlemaid.compat.tacz.TacCompat.MINIGUN_ID;

@Environment(EnvType.CLIENT)
public class GunBaseAnimation {
    public static boolean onHoldGun(IMaid maid, @Nullable ModelRendererWrapper armLeft, @Nullable ModelRendererWrapper armRight) {
        class_1308 mob = maid.asEntity();
        if (mob == null) {
            return false;
        }
        class_1799 handItem = mob.method_6047();
        IGun gun = IGun.getIGunOrNull(handItem);
        if (gun == null) {
            return false;
        }
        class_2960 gunId = gun.getGunId(handItem);

        // 因为现在还没有 minigun 的专属标签，故只能用特判
        if (gunId.equals(MINIGUN_ID)) {
            if (armLeft != null) {
                armLeft.setRotateAngleX(-1.45f);
                armLeft.setRotateAngleY(1f);
            }
            if (armRight != null) {
                armRight.setRotateAngleX(0.75f);
                armRight.setRotateAngleY(0);
            }
            return true;
        }

        if (armLeft != null) {
            armLeft.setRotateAngleX(-1.75f);
            armLeft.setRotateAngleY(0.5f);
        }
        if (armRight != null) {
            armRight.setRotateAngleX(-1.65f);
            armRight.setRotateAngleY(-0.174f);
        }
        return true;
    }
}
