package com.github.tartaricacid.touhoulittlemaid.datagen.advancement;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_8779;


public class ChallengeAdvancement {
    public static void generate(Consumer<class_8779> saver) {
        class_8779 root = make(class_1802.field_8743, "any_equipment")
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.ANY_EQUIPMENT))
                .method_694(saver, id("challenge/any_equipment").toString());

        generateProtect(root, saver);

        generateKill(root, saver);
    }

    private static void generateProtect(class_8779 root, Consumer<class_8779> saver) {
        class_8779 protect = make(class_1802.field_8367, "eat_enchanted_golden_apple").method_701(root)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.EAT_ENCHANTED_GOLDEN_APPLE))
                .method_694(saver, id("challenge/eat_enchanted_golden_apple").toString());

        makeChallenge(InitItems.ALL_NETHERITE_EQUIPMENT, "all_netherite_equipment").method_701(protect)
                .method_703(class_170.class_171.method_750(50))
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.ALL_NETHERITE_EQUIPMENT))
                .method_694(saver, id("challenge/all_netherite_equipment").toString());

        class_1799 stack = ItemEntityPlaceholder.setRecipeId(new class_1799(InitItems.ENTITY_PLACEHOLDER), "spawn_lightning_bolt");
        class_8779 lightningBolt = make(stack, "lightning_bolt").method_701(protect)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.LIGHTNING_BOLT))
                .method_694(saver, id("challenge/lightning_bolt").toString());

        makeGoal(InitItems.MAID_100_HEALTHY, "maid_100_healthy").method_701(lightningBolt)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.MAID_100_HEALTHY))
                .method_694(saver, id("challenge/maid_100_healthy").toString());
    }

    private static void generateKill(class_8779 root, Consumer<class_8779> saver) {
        class_8779 kill = makeGoal(InitItems.KILL_100, "kill_100").method_701(root)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.KILL_100))
                .method_703(class_170.class_171.method_750(50))
                .method_694(saver, id("challenge/kill_100").toString());

        makeChallenge(InitItems.KILL_SLIME_300, "kill_slime_300").method_701(kill)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.KILL_SLIME_300))
                .method_703(class_170.class_171.method_750(50))
                .method_694(saver, id("challenge/kill_slime_300").toString());

        class_8779 wither = makeChallenge(InitItems.KILL_WITHER, "kill_wither").method_701(kill)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.KILL_WITHER))
                .method_694(saver, id("challenge/kill_wither").toString());

        makeChallenge(InitItems.KILL_DRAGON, "kill_dragon").method_701(wither)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.KILL_DRAGON))
                .method_694(saver, id("challenge/kill_dragon").toString());
    }

    private static void generateOther(class_8779 root, Consumer<class_8779> saver) {
        makeGoal(class_1802.field_8598, "maid_fishing_enchanted_book").method_701(root)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.MAID_FISHING_ENCHANTED_BOOK))
                .method_694(saver, id("challenge/maid_fishing_enchanted_book").toString());

        makeGoal(class_1802.field_17534, "tamed_maid_in_pillager_outpost").method_701(root)
                .method_705("maid_event", MaidEventTrigger.create(TriggerType.TAMED_MAID_FROM_STRUCTURE))
                .method_694(saver, id("challenge/tamed_maid_in_pillager_outpost").toString());
    }

    private static class_161.class_162 make(class_1935 item, String key) {
        class_5250 title = class_2561.method_43471(String.format("advancements.touhou_little_maid.challenge.%s.title", key));
        class_5250 desc = class_2561.method_43471(String.format("advancements.touhou_little_maid.challenge.%s.description", key));

        return class_161.class_162.method_707().method_697(item, title, desc,
                class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/advancements/backgrounds/stone.png"),
                class_189.field_1254, true, true, false);
    }

    private static class_161.class_162 make(class_1799 item, String key) {
        class_5250 title = class_2561.method_43471(String.format("advancements.touhou_little_maid.challenge.%s.title", key));
        class_5250 desc = class_2561.method_43471(String.format("advancements.touhou_little_maid.challenge.%s.description", key));

        return class_161.class_162.method_707().method_20416(item, title, desc,
                class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/advancements/backgrounds/stone.png"),
                class_189.field_1254, true, true, false);
    }

    private static class_161.class_162 makeGoal(class_1935 item, String key) {
        class_5250 title = class_2561.method_43471(String.format("advancements.touhou_little_maid.challenge.%s.title", key));
        class_5250 desc = class_2561.method_43471(String.format("advancements.touhou_little_maid.challenge.%s.description", key));

        return class_161.class_162.method_707().method_697(item, title, desc,
                class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/advancements/backgrounds/stone.png"),
                class_189.field_1249, true, true, false);
    }

    private static class_161.class_162 makeChallenge(class_1935 item, String key) {
        class_5250 title = class_2561.method_43471(String.format("advancements.touhou_little_maid.challenge.%s.title", key));
        class_5250 desc = class_2561.method_43471(String.format("advancements.touhou_little_maid.challenge.%s.description", key));

        return class_161.class_162.method_707().method_697(item, title, desc,
                class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/advancements/backgrounds/stone.png"),
                class_189.field_1250, true, true, false);
    }

    private static class_2960 id(String id) {
        return class_2960.method_60655(TouhouLittleMaid.MOD_ID, id);
    }
}
