package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.CombinedInvWrapper;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemHandlerHelper;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1820;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4215;
import net.minecraft.class_4481;
import net.minecraft.class_7473;
import javax.annotation.Nullable;
import java.util.Comparator;

public class MaidCollectHoneyTask extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 100;
    private final float speed;
    private final int closeEnoughDist;

    public MaidCollectHoneyTask(float speed, int closeEnoughDist) {
        super(ImmutableMap.of(class_4140.field_18445, class_4141.field_18457,
                InitEntities.TARGET_POS, class_4141.field_18457));
        this.speed = speed;
        this.closeEnoughDist = closeEnoughDist;
        this.setMaxCheckRate(MAX_DELAY_TIME);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid maid) {
        if (super.checkExtraStartConditions(worldIn, maid) && maid.canBrainMoving()) {
            class_2338 beehivePos = findBeehive(worldIn, maid);
            if (beehivePos != null && maid.method_18407(beehivePos)) {
                if (beehivePos.method_19770(maid.method_19538()) < Math.pow(this.closeEnoughDist, 2)) {
                    maid.method_18868().method_18878(InitEntities.TARGET_POS, new class_4099(beehivePos));
                    return true;
                }
                class_4215.method_24561(maid, beehivePos, speed, 1);
                this.setNextCheckTickCount(5);
            } else {
                maid.method_18868().method_18875(InitEntities.TARGET_POS);
            }
        }
        return false;
    }

    @Override
    protected void start(class_3218 level, EntityMaid maid, long gameTime) {
        maid.method_18868().method_18904(InitEntities.TARGET_POS).ifPresent(target -> {
            class_2338 hivePos = target.method_18989();
            class_2680 hiveBlockState = level.method_8320(hivePos);
            if (!hiveBlockState.method_28498(class_4481.field_20420)) {
                return;
            }
            if (hiveBlockState.method_11654(class_4481.field_20420) < 5) {
                return;
            }
            CombinedInvWrapper maidAvailableInv = maid.getAvailableInv(true);
            if (!this.collectHoneyComb(level, maid, maidAvailableInv, hiveBlockState, hivePos)) {
                this.collectHoneyBottle(level, maid, maidAvailableInv, hiveBlockState, hivePos);
            }
        });
        maid.method_18868().method_18875(InitEntities.TARGET_POS);
        maid.method_18868().method_18875(class_4140.field_18446);
        maid.method_18868().method_18875(class_4140.field_18445);
    }

    private void collectHoneyBottle(class_3218 level, EntityMaid maid, CombinedInvWrapper maidAvailableInv, class_2680 hiveBlockState, class_2338 hivePos) {
        class_1799 bottle = ItemsUtil.getStack(maidAvailableInv, stack -> stack.method_31574(class_1802.field_8469));
        if (!bottle.method_7960()) {
            class_1799 honeyBottle = new class_1799(class_1802.field_20417);
            class_1799 result = ItemHandlerHelper.insertItemStacked(maidAvailableInv, honeyBottle, true);
            // 背包满了就不收集了
            if (!result.method_7960()) {
                return;
            }
            bottle.method_7934(1);
            level.method_43128(null, maid.method_23317(), maid.method_23318(), maid.method_23321(), class_3417.field_14779, class_3419.field_15245, 1.0F, 1.0F);
            ItemHandlerHelper.insertItemStacked(maidAvailableInv, honeyBottle, false);
            resetHoneyLevel(level, hiveBlockState, hivePos);
            maid.method_6104(class_1268.field_5808);
        }
    }

    private boolean collectHoneyComb(class_3218 level, EntityMaid maid, CombinedInvWrapper maidAvailableInv, class_2680 hiveBlockState, class_2338 hivePos) {
        //boolean hasShears = maid.getMainHandItem().canPerformAction(ItemAbilities.SHEARS_HARVEST);
        boolean hasShears = maid.method_6047().method_31573(ConventionalItemTags.SHEAR_TOOLS) || maid.method_6047().method_7909() instanceof class_1820;
        if (hasShears) {
            class_1799 honeyComb = new class_1799(class_1802.field_20414, 3);
            class_1799 result = ItemHandlerHelper.insertItemStacked(maidAvailableInv, honeyComb, true);
            // 背包满了就不收集了
            if (!result.method_7960()) {
                return false;
            }
            level.method_43128(null, maid.method_23317(), maid.method_23318(), maid.method_23321(), class_3417.field_20611, class_3419.field_15245, 1.0F, 1.0F);
            ItemHandlerHelper.insertItemStacked(maidAvailableInv, honeyComb, false);
            resetHoneyLevel(level, hiveBlockState, hivePos);
            maid.method_6104(class_1268.field_5808);
            maid.method_6047().method_7970(1, maid, class_1304.field_6173);
            return true;
        }
        return false;
    }

    @Nullable
    private class_2338 findBeehive(class_3218 world, EntityMaid maid) {
        class_2338 blockPos = maid.getBrainSearchPos();
        class_4153 poiManager = world.method_19494();
        int range = (int) maid.method_18413();
        return poiManager.method_19125(type -> type.method_40220(class_7473.field_39264), blockPos, range, class_4153.class_4155.field_18489)
                .map(class_4156::method_19141).filter(pos -> canCollectHoney(world, pos))
                .min(Comparator.comparingDouble(pos -> pos.method_10262(maid.method_24515()))).orElse(null);
    }

    private boolean canCollectHoney(class_3218 world, class_2338 hivePos) {
        class_2680 state = world.method_8320(hivePos);
        if (state.method_28498(class_4481.field_20420)) {
            return state.method_11654(class_4481.field_20420) >= 5;
        }
        return false;
    }

    public void resetHoneyLevel(class_1937 level, class_2680 state, class_2338 pos) {
        if (state.method_28498(class_4481.field_20420)) {
            level.method_8652(pos, state.method_11657(class_4481.field_20420, 0), class_2248.field_31036);
        }
    }
}
