package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class MaidFollowOwnerTask extends class_4097<EntityMaid> {
    private final float speedModifier;
    private final int stopDistance;

    public MaidFollowOwnerTask(float speedModifier, int stopDistance) {
        super(ImmutableMap.of(class_4140.field_18445, class_4141.field_18458));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 level, EntityMaid maid) {
        class_1309 owner = maid.method_35057();
        if (ownerStateConditions(owner, maid)) {
            // 如果女仆在前往呼吸点，玩家不在水中
            if (maid.getSwimManager().isGoingToBreath()) {
                return !owner.method_5869();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        class_1309 owner = maid.method_35057();

        // 如果女仆在前往呼吸点快要淹死了，那必须就近传送
        // 这个传送会鬼畜，但是没办法，为了救女仆只能这样了
        if (maid.getSwimManager().isGoingToBreath() && ownerStateConditions(owner, maid)
                && maidStateConditions(maid) && maid.teleportToOwner(owner)) {
            maid.getNavigationManager().resetNavigation();
            maid.getSwimManager().setGoingToBreath(false);
            maid.method_18868().method_18875(class_4140.field_18445);
            maid.method_18868().method_18875(InitEntities.TARGET_POS);
            this.method_18925(worldIn, maid, gameTimeIn);
            return;
        }

        // 否则正常传送
        int startDistance = (int) maid.method_18413() - 2;
        int minTeleportDistance = startDistance + 4;
        if (ownerStateConditions(owner, maid) && maidStateConditions(maid) && !maid.method_24516(owner, startDistance)) {
            if (!maid.method_24516(owner, minTeleportDistance)) {
                maid.teleportToOwner(owner);
                maid.getNavigationManager().resetNavigation();
            } else if (!ownerIsWalkTarget(maid, owner)) {
                class_4215.method_24557(maid, owner, speedModifier, stopDistance);
            }
        }
    }

    private boolean maidStateConditions(EntityMaid maid) {
        return !maid.isHomeModeEnable() && maid.canBrainMoving();
    }

    private boolean ownerStateConditions(@Nullable class_1309 owner, EntityMaid maid) {
        return owner != null && !owner.method_7325() && !owner.method_29504() &&
                // 修复一个过去很多年没解决的 bug —— 女仆神秘传送问题
                // 这个 bug 的原因是，传送时没有检查女仆和主人是否在同一个维度
                maid.field_6002 == owner.field_6002;
    }

    private boolean ownerIsWalkTarget(EntityMaid maid, class_1309 owner) {
        return maid.method_18868().method_18904(class_4140.field_18445).map(target -> {
            if (target.method_19094() instanceof class_4102 tracker) {
                return tracker.method_35066().equals(owner);
            }
            return false;
        }).orElse(false);
    }
}