package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_4215;

public class MaidUpdateActivityFromSchedule extends class_4097<EntityMaid> {
    private class_4168 cacheActivity;

    public MaidUpdateActivityFromSchedule() {
        super(ImmutableMap.of());
    }

    @Override
    protected void start(class_3218 level, EntityMaid maid, long gameTime) {
        class_4095<EntityMaid> brain = maid.method_18868();
        long dayTime = level.method_8532();

        // 让女仆在切换日程表时能够改变自己的活动范围
        if (gameTime - brain.field_18853 > 20L) {
            class_4168 activity = brain.method_18894().method_19213((int) (dayTime % 24000L));
            if (this.cacheActivity == null) {
                this.cacheActivity = activity;
            }
            if (!this.cacheActivity.equals(activity) && maid.isHomeModeEnable() && maid.canBrainMoving()) {
                this.cacheActivity = activity;
                maid.getSchedulePos().restrictTo(maid);
                class_4215.method_24561(maid, maid.method_18412(), 0.7f, 3);
            }
        }

        // 切换日程表，分骑乘和非骑乘两种情况
        updateActivityFromSchedule(level, maid, brain, gameTime);
    }

    public static void updateActivityFromSchedule(EntityMaid maid, class_4095<EntityMaid> brain) {
        if (maid.field_6002 instanceof class_3218 serverLevel) {
            long gameTime = serverLevel.method_8510();
            updateActivityFromSchedule(serverLevel, maid, brain, gameTime);
        }
    }

    public static void updateActivityFromSchedule(EntityMaid maid) {
        if (maid.field_6002 instanceof class_3218 serverLevel) {
            long gameTime = serverLevel.method_8510();
            class_4095<EntityMaid> brain = maid.method_18868();
            updateActivityFromSchedule(serverLevel, maid, brain, gameTime);
        }
    }

    private static void updateActivityFromSchedule(class_3218 level, EntityMaid maid, class_4095<EntityMaid> brain, long gameTime) {
        long dayTime = level.method_8532();
        if (maid.isMaidInSittingPose() || maid.method_5765()) {
            if (gameTime - brain.field_18853 > 20L) {
                brain.field_18853 = gameTime;
                class_4168 activity = brain.method_18894().method_19213((int) (dayTime % 24000L));
                class_4168 riderActivity;
                if (activity.equals(class_4168.field_18596)) {
                    riderActivity = InitEntities.RIDE_WORK;
                } else if (activity.equals(class_4168.field_18595)) {
                    riderActivity = InitEntities.RIDE_IDLE;
                } else {
                    riderActivity = InitEntities.RIDE_REST;
                }
                if (!brain.method_18906(riderActivity)) {
                    brain.method_18875(class_4140.field_18449);
                    brain.method_18875(class_4140.field_18445);
                    brain.method_24526(riderActivity);

                    // 如果是拥有工作点的 task，需要脱离骑乘的实体
                    if (maid.method_5765() && !riderActivity.equals(InitEntities.RIDE_WORK)) {
                        if (!maid.getTask().workPointTask(maid)) {
                            return;
                        }
                        // 特殊的实体（比如娱乐工具的，就不需要脱离）
                        if (maid.method_5854() instanceof EntitySit) {
                            return;
                        }
                        maid.method_5848();
                    }
                }
            }
        } else {
            brain.method_18871(dayTime, level.method_8510());
        }
    }
}
