package com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation;

import cn.sh1rocu.touhoulittlemaid.util.forge.CommonHooks;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_14;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_7;
import net.minecraft.class_9;
import net.minecraft.class_9316;

/**
 * 该方法仅修改了栅栏门和梯子的寻路判断
 */
public class MaidNodeEvaluator extends class_14 {
    @Override
    public class_7 method_17(class_9316 pContext, int pX, int pY, int pZ) {
        return getMaidBlockPathTypeStatic(pContext, new class_2338.class_2339(pX, pY, pZ));
    }

    @Override
    public int method_18(class_9[] outputArray, class_9 node) {
        int nodeId = super.method_18(outputArray, node);
        return this.createClimbNode(nodeId, outputArray, node);
    }

    // 将可爬行物加入寻路节点里头
    // 一般这些物体都是相连的，所以向上向下搜寻下
    protected int createClimbNode(int nodeId, class_9[] nodes, class_9 origin) {
        // 只有在开启攀爬能力，才将梯子加入寻路节点里
        if (this.field_33 instanceof EntityMaid maid && maid.getConfigManager().isActiveClimbing()) {
            // 向上搜寻
            class_2338.class_2339 upPos = new class_2338.class_2339(origin.field_40, origin.field_39 + 1, origin.field_38);
            if (isMaidCanClimbBlock(upPos, maid)) {
                class_9 node = this.method_27137(upPos);
                if (!node.field_42) {
                    node.field_43 = 0;
                    node.field_41 = class_7.field_12;
                    if (nodeId + 1 < nodes.length) {
                        nodes[nodeId++] = node;
                    }
                }
            }
            // 向下搜寻
            class_2338.class_2339 downPos = new class_2338.class_2339(origin.field_40, origin.field_39 - 1, origin.field_38);
            if (isMaidCanClimbBlock(downPos, maid)) {
                class_9 node = this.method_27137(downPos);
                if (!node.field_42) {
                    node.field_43 = 0;
                    node.field_41 = class_7.field_12;
                    if (nodeId + 1 < nodes.length) {
                        nodes[nodeId++] = node;
                    }
                }
            }
        }
        return nodeId;
    }

    private class_7 getMaidBlockPathTypeStatic(class_9316 context, class_2338.class_2339 pos) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();

        class_7 pathType = getMaidBlockPathTypeRaw(context, x, y, z);
        if (pathType == class_7.field_7 && y >= context.method_57621().method_31607() + 1) {
            return switch (getMaidBlockPathTypeRaw(context, x, y - 1, z)) {
                case field_7, field_18, field_14, field_12 -> class_7.field_7;
                case field_3 -> class_7.field_3;
                case field_17 -> class_7.field_17;
                case field_21326 -> class_7.field_21326;
                case field_33534 -> class_7.field_36432;
                case field_43351 -> class_7.field_43351;
                case field_19 -> class_7.field_47413;
                default -> method_59(context, x, y, z, class_7.field_12);
            };
        } else {
            return pathType;
        }
    }

    private class_7 getMaidBlockPathTypeRaw(class_9316 context, int pX, int pY, int pZ) {
        class_2338 pos = new class_2338(pX, pY, pZ);
        // 女仆在限定范围内寻路寻到了范围外，失败
        if (this.field_33 instanceof EntityMaid maid && maid.method_18411() && !maid.method_18407(pos)) {
            return class_7.field_22;
        }
        class_2680 blockState = context.method_57623(pos);
        class_7 pathType;
        if (blockState.method_26204() instanceof class_2349) {
            pathType = blockState.method_11654(class_2349.field_11026) ? class_7.field_15 : class_7.field_23;
        } else if (this.field_33 instanceof EntityMaid maid && this.canClimb(blockState, pos, maid)) {
            // 将楼梯视为可行走方块，便于后续将楼梯加入路径节点
            pathType = class_7.field_12;
        } else {
            pathType = context.method_57622(pX, pY, pZ);
            // 判断目标方块的碰撞高度。有些半透明方块拥有超过 0.5（台阶）的高度，此时女仆是不能从其中穿过的，需要将其视为不可通行方块
            if (!heightCheckExclusions(pathType) && this.field_33 != null) {
                class_265 shape = blockState.method_26220(this.field_33.field_6002, pos);
                if (pathType != class_7.field_22 && shape.method_1105(class_2350.class_2351.field_11052) - shape.method_1091(class_2350.class_2351.field_11052) > 0.5) {
                    pathType = class_7.field_22;
                }
            }
        }
        if (pathType == class_7.field_23 && this.field_33 instanceof EntityMaid maid && !this.canOpenDoor(blockState.method_26204(), maid)) {
            pathType = class_7.field_8;
        }
        return pathType;
    }

    private boolean heightCheckExclusions(class_7 pathType) {
        return pathType == class_7.field_15 || pathType == class_7.field_23;
    }

    private boolean canOpenDoor(class_2248 block, EntityMaid maid) {
        if (block instanceof class_2323) {
            return maid.getConfigManager().isOpenDoor();
        }
        if (block instanceof class_2349) {
            return maid.getConfigManager().isOpenFenceGate();
        }
        return true;
    }

    private boolean canClimb(class_2680 blockState, class_2338 blockPos, EntityMaid maid) {
        if (isMaidCanClimbBlock(blockState, blockPos, maid)) {
            return maid.getConfigManager().isActiveClimbing();
        }
        return false;
    }

    public static boolean isMaidCanClimbBlock(class_2338 blockPos, EntityMaid maid) {
        class_1937 level = maid.field_6002;
        class_2680 blockState = level.method_8320(blockPos);
        return isMaidCanClimbBlock(blockState, blockPos, maid);
    }

    public static boolean isMaidCanClimbBlock(class_2680 blockState, class_2338 blockPos, EntityMaid maid) {
        return CommonHooks.isLadder(blockState, maid.field_6002, blockPos, maid);
    }
}