package com.github.tartaricacid.touhoulittlemaid.entity.data.inner;

import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2960;

public record AttackListData(Map<class_2960, MonsterType> attackGroups) {
    private static final Codec<Map<class_2960, MonsterType>> LIST_CODEC = Codec.unboundedMap(class_2960.field_25139, MonsterType.CODEC)
            .xmap(HashMap::new, Function.identity());
    public static final Codec<AttackListData> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            LIST_CODEC.fieldOf("attack_groups").forGetter(AttackListData::attackGroups)
    ).apply(instance, AttackListData::new));

    public static AttackListData empty() {
        return new AttackListData(Maps.newHashMap());
    }
}
