package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import net.minecraft.class_1297;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public abstract class GeoLayerRenderer<T extends class_1297, R extends IGeoEntityRenderer<T>> {
    protected final R entityRenderer;

    public GeoLayerRenderer(R entityRendererIn) {
        this.entityRenderer = entityRendererIn;
    }

    public R getRenderer() {
        return this.entityRenderer;
    }

    public IGeoEntity getGeoEntity(T entity) {
        return this.getRenderer().getGeoEntity(entity);
    }

    protected ILocationModel getLocationModel(T entity) {
        return this.getGeoEntity(entity).getGeoModel();
    }

    public abstract GeoLayerRenderer<T, R> copy(R entityRendererIn);

    public abstract void render(class_4587 poseStack, class_4597 bufferSource, int packedLight,
                                T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks,
                                float netHeadYaw, float headPitch);
}